package com.temboo.Library.NYTimes.EventListings;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SearchWithinBoundedBox

Allows you to do a spatial search for events within a box bounded by specified northeast and southwest points.
*/
public class SearchWithinBoundedBox extends Choreography {

	/**
	Create a new instance of the SearchWithinBoundedBox Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SearchWithinBoundedBox(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/NYTimes/EventListings/SearchWithinBoundedBox"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SearchWithinBoundedBoxInputSet
	*/
	public SearchWithinBoundedBoxInputSet newInputSet() {
		return new SearchWithinBoundedBoxInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SearchWithinBoundedBoxResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SearchWithinBoundedBoxResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SearchWithinBoundedBox
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SearchWithinBoundedBoxInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by NY Times.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the DateRange input for this Choreo. 

		@param String - (optional, date) Start date to end date in the following format: YYYY-MM-DD:YYYY-MM-DD.
		*/
		public void set_DateRange(String value) {
			this.setInput("DateRange", value);
		}


		/** 
		Set the value of the Filters input for this Choreo. 

		@param String - (optional, string) Filters search results using facet names and values. See Choreo documentation for examples.
		*/
		public void set_Filters(String value) {
			this.setInput("Filters", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) The number of results to return.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to return.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the NortheastLatitude input for this Choreo. 

		@param BigDecimal - (conditional, decimal) The northeastern latitude of the bounding box to search. When searching within a bounded box, all four coordinates are required.
		*/
		public void set_NortheastLatitude(BigDecimal value) {
			this.setInput("NortheastLatitude", value);
		}

		/** 
		Set the value of the NortheastLatitude input for this Choreo as a String. 

		@param String - (conditional, decimal) The northeastern latitude of the bounding box to search. When searching within a bounded box, all four coordinates are required.
		*/
		public void set_NortheastLatitude(String value) {
			this.setInput("NortheastLatitude", value);	
		}
		/** 
		Set the value of the NortheastLongitude input for this Choreo. 

		@param BigDecimal - (conditional, decimal) The northeastern longitude of the bounding box to search. When searching within a bounded box, all four coordinates are required.
		*/
		public void set_NortheastLongitude(BigDecimal value) {
			this.setInput("NortheastLongitude", value);
		}

		/** 
		Set the value of the NortheastLongitude input for this Choreo as a String. 

		@param String - (conditional, decimal) The northeastern longitude of the bounding box to search. When searching within a bounded box, all four coordinates are required.
		*/
		public void set_NortheastLongitude(String value) {
			this.setInput("NortheastLongitude", value);	
		}
		/** 
		Set the value of the Offset input for this Choreo. 

		@param Integer - (optional, integer) A numeric value indicating the starting point of the result set. This can be used in combination with the Limit input to page through results.
		*/
		public void set_Offset(Integer value) {
			this.setInput("Offset", value);
		}

		/** 
		Set the value of the Offset input for this Choreo as a String. 

		@param String - (optional, integer) A numeric value indicating the starting point of the result set. This can be used in combination with the Limit input to page through results.
		*/
		public void set_Offset(String value) {
			this.setInput("Offset", value);	
		}
		/** 
		Set the value of the Query input for this Choreo. 

		@param String - (optional, string) Search keywords to perform a text search on the following fields: web_description, event_name and venue_name.
		*/
		public void set_Query(String value) {
			this.setInput("Query", value);
		}


		/** 
		Set the value of the Radius input for this Choreo. 

		@param Integer - (optional, integer) The radius of the spacial search (in meters). Defaults to 1000.
		*/
		public void set_Radius(Integer value) {
			this.setInput("Radius", value);
		}

		/** 
		Set the value of the Radius input for this Choreo as a String. 

		@param String - (optional, integer) The radius of the spacial search (in meters). Defaults to 1000.
		*/
		public void set_Radius(String value) {
			this.setInput("Radius", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Can be set to json, xml, or sphp. Defaults to xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Sort input for this Choreo. 

		@param String - (optional, string) Allows you to sort results. Appending "+asc" or "+desc" to a facet will sort results on that value in ascending or descending order (i.e. dist+asc).
		*/
		public void set_Sort(String value) {
			this.setInput("Sort", value);
		}


		/** 
		Set the value of the SouthwestLatitude input for this Choreo. 

		@param BigDecimal - (conditional, decimal) The southwest latitude of the bounding box to search. When searching within a bounded box, all four coordinates are required.
		*/
		public void set_SouthwestLatitude(BigDecimal value) {
			this.setInput("SouthwestLatitude", value);
		}

		/** 
		Set the value of the SouthwestLatitude input for this Choreo as a String. 

		@param String - (conditional, decimal) The southwest latitude of the bounding box to search. When searching within a bounded box, all four coordinates are required.
		*/
		public void set_SouthwestLatitude(String value) {
			this.setInput("SouthwestLatitude", value);	
		}
		/** 
		Set the value of the SouthwestLongitude input for this Choreo. 

		@param BigDecimal - (conditional, decimal) The southwest longitude of the bounding box to search. When searching within a bounded box, all four coordinates are required.
		*/
		public void set_SouthwestLongitude(BigDecimal value) {
			this.setInput("SouthwestLongitude", value);
		}

		/** 
		Set the value of the SouthwestLongitude input for this Choreo as a String. 

		@param String - (conditional, decimal) The southwest longitude of the bounding box to search. When searching within a bounded box, all four coordinates are required.
		*/
		public void set_SouthwestLongitude(String value) {
			this.setInput("SouthwestLongitude", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SearchWithinBoundedBox Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SearchWithinBoundedBoxResultSet extends ResultSet {
		public SearchWithinBoundedBoxResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from the NY Times API. Valid values are: json (the default) and xml.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
