package com.temboo.Library.NYTimes.CampaignFinance.IndividualContributors;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ContributionsToPresidentialCandidates

Retrieve contributions made by individuals to a specific presidential candidate. 
*/
public class ContributionsToPresidentialCandidates extends Choreography {

	/**
	Create a new instance of the ContributionsToPresidentialCandidates Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ContributionsToPresidentialCandidates(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/NYTimes/CampaignFinance/IndividualContributors/ContributionsToPresidentialCandidates"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ContributionsToPresidentialCandidatesInputSet
	*/
	public ContributionsToPresidentialCandidatesInputSet newInputSet() {
		return new ContributionsToPresidentialCandidatesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ContributionsToPresidentialCandidatesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ContributionsToPresidentialCandidatesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ContributionsToPresidentialCandidates
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ContributionsToPresidentialCandidatesInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by NY Times.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the CampaignCycle input for this Choreo. 

		@param Integer - (required, integer) Enter the campaign cycle year in YYYY format.  This must be an even year.
		*/
		public void set_CampaignCycle(Integer value) {
			this.setInput("CampaignCycle", value);
		}

		/** 
		Set the value of the CampaignCycle input for this Choreo as a String. 

		@param String - (required, integer) Enter the campaign cycle year in YYYY format.  This must be an even year.
		*/
		public void set_CampaignCycle(String value) {
			this.setInput("CampaignCycle", value);	
		}
		/** 
		Set the value of the CandidateFECID input for this Choreo. 

		@param String - (conditional, string) Enter a candidate's nine-digit FEC ID. IDs can be obtained by first running the CandidateSearch Choreo. Required unless providing the LastName input.
		*/
		public void set_CandidateFECID(String value) {
			this.setInput("CandidateFECID", value);
		}


		/** 
		Set the value of the LastName input for this Choreo. 

		@param String - (conditional, string) Enter the name of a presidential candidate for whom contributions will be obtained. Required unless providing the CandidateFECID input.
		*/
		public void set_LastName(String value) {
			this.setInput("LastName", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) Enter json or xml.  Default is json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ContributionsToPresidentialCandidates Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ContributionsToPresidentialCandidatesResultSet extends ResultSet {
		public ContributionsToPresidentialCandidatesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from the NY Times API corresponds to the setting (json, or xml) entered in the ResponseFormat variable.  Default is set to json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
