package com.temboo.Library.Microsoft.PowerBI;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
AddRow

Adds rows to a table in a dataset
*/
public class AddRow extends Choreography {

	/**
	Create a new instance of the AddRow Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public AddRow(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Microsoft/PowerBI/AddRow"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return AddRowInputSet
	*/
	public AddRowInputSet newInputSet() {
		return new AddRowInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public AddRowResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new AddRowResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the AddRow
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class AddRowInputSet extends InputSet {
		/** 
		Set the value of the Rows input for this Choreo. 

		@param String - (required, json) A JSON object contain one or more rows to insert into a Power BI table. See Choreo notes for formatting details.
		*/
		public void set_Rows(String value) {
			this.setInput("Rows", value);
		}


		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid Access Token retrieved during the OAuth process. This can be passed if your application is authenticating multiple Power BI users.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Power BI. This is requried unless providing a valid AccessToken (see optional inputs).
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by Power BI. This is requried unless providing a valid AccessToken (see optional inputs).
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the DatasetID input for this Choreo. 

		@param String - (required, string) The ID of the dataset that your table belongs to.
		*/
		public void set_DatasetID(String value) {
			this.setInput("DatasetID", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (conditional, password) Your Power BI password. This is requried unless providing a valid AccessToken (see optional inputs).
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the TableName input for this Choreo. 

		@param String - (required, string) The name of the Power BI table to insert a row into.
		*/
		public void set_TableName(String value) {
			this.setInput("TableName", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (conditional, string) Your Power BI username. This is requried unless providing a valid AccessToken (see optional inputs).
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the AddRow Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class AddRowResultSet extends ResultSet {
		public AddRowResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "ResponseCode" output from this Choreo execution

		@return String - (integer) The response status code returned from Power BI.
		*/
		public String get_ResponseCode() {
			return this.getResultString("ResponseCode");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Power BI.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
