package com.temboo.Library.MailChimp;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListUpdateMember

Update information for a member of a MailChimp list.
*/
public class ListUpdateMember extends Choreography {

	/**
	Create a new instance of the ListUpdateMember Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListUpdateMember(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/MailChimp/ListUpdateMember"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListUpdateMemberInputSet
	*/
	public ListUpdateMemberInputSet newInputSet() {
		return new ListUpdateMemberInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListUpdateMemberResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListUpdateMemberResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListUpdateMember
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListUpdateMemberInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Mailchimp.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the EmailAddress input for this Choreo. 

		@param String - (required, string) The current email address for the subscriber you want to update.
		*/
		public void set_EmailAddress(String value) {
			this.setInput("EmailAddress", value);
		}


		/** 
		Set the value of the EmailType input for this Choreo. 

		@param String - (optional, string) Must be one of 'text', 'html', or 'mobile'. Defaults to html.
		*/
		public void set_EmailType(String value) {
			this.setInput("EmailType", value);
		}


		/** 
		Set the value of the ListId input for this Choreo. 

		@param String - (required, string) The id of the list that the existing subsbriber belongs to.
		*/
		public void set_ListId(String value) {
			this.setInput("ListId", value);
		}


		/** 
		Set the value of the Merge1 input for this Choreo. 

		@param String - (optional, string) Corresponds to the first merge var field defined in your account.
		*/
		public void set_Merge1(String value) {
			this.setInput("Merge1", value);
		}


		/** 
		Set the value of the Merge2 input for this Choreo. 

		@param String - (optional, string) Corresponds to the second merge var field defined in your account.
		*/
		public void set_Merge2(String value) {
			this.setInput("Merge2", value);
		}


		/** 
		Set the value of the Merge3 input for this Choreo. 

		@param String - (optional, string) Corresponds to the third merge var field defined in your account.
		*/
		public void set_Merge3(String value) {
			this.setInput("Merge3", value);
		}


		/** 
		Set the value of the Merge4 input for this Choreo. 

		@param String - (optional, string) Corresponds to the fourth merge var field defined in your account.
		*/
		public void set_Merge4(String value) {
			this.setInput("Merge4", value);
		}


		/** 
		Set the value of the NewEmail input for this Choreo. 

		@param String - (optional, multiline) Set this to update the email address of a subscriber.
		*/
		public void set_NewEmail(String value) {
			this.setInput("NewEmail", value);
		}


		/** 
		Set the value of the ReplaceInterests input for this Choreo. 

		@param Boolean - (optional, boolean) A flag to determine whether to replace the interest groups with the groups provided or add the provided groups to the member's interest groups. Specify '1' (true) or '0' (false). Defaults to 1.
		*/
		public void set_ReplaceInterests(Boolean value) {
			this.setInput("ReplaceInterests", value);
		}

		/** 
		Set the value of the ReplaceInterests input for this Choreo as a String. 

		@param String - (optional, boolean) A flag to determine whether to replace the interest groups with the groups provided or add the provided groups to the member's interest groups. Specify '1' (true) or '0' (false). Defaults to 1.
		*/
		public void set_ReplaceInterests(String value) {
			this.setInput("ReplaceInterests", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListUpdateMember Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListUpdateMemberResultSet extends ResultSet {
		public ListUpdateMemberResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Mailchimp. Returns the string "true" for success and an error description for failures.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
