package com.temboo.Library.Labs.Social;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetContacts

Retrieves your social contacts from multiple APIs in one API call.
*/
public class GetContacts extends Choreography {

	/**
	Create a new instance of the GetContacts Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetContacts(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Labs/Social/GetContacts"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetContactsInputSet
	*/
	public GetContactsInputSet newInputSet() {
		return new GetContactsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetContactsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetContactsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetContacts
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetContactsInputSet extends InputSet {
		/** 
		Set the value of the APICredentials input for this Choreo. 

		@param String - (conditional, json) A list of credentials for the APIs you wish to access. See Choreo documentation for formatting examples.
		*/
		public void set_APICredentials(String value) {
			this.setInput("APICredentials", value);
		}


		/** 
		Set the value of the ScreenName input for this Choreo. 

		@param String - (conditional, string) The Twitter screen name to retrieve followers for.
		*/
		public void set_ScreenName(String value) {
			this.setInput("ScreenName", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetContacts Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetContactsResultSet extends ResultSet {
		public GetContactsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) Contains the merged results from the API responses.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
