package com.temboo.Library.Kiva.Loans;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetLenders

Returns a list of public lenders to a loan.
*/
public class GetLenders extends Choreography {

	/**
	Create a new instance of the GetLenders Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetLenders(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Kiva/Loans/GetLenders"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetLendersInputSet
	*/
	public GetLendersInputSet newInputSet() {
		return new GetLendersInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetLendersResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetLendersResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetLenders
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetLendersInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (optional, string) Your unique application ID, usually in reverse DNS notation.
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the LoanID input for this Choreo. 

		@param String - (required, string) The ID of the loan for which to get details.
		*/
		public void set_LoanID(String value) {
			this.setInput("LoanID", value);
		}


		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) The page position of results to return. Defaults to 1.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) The page position of results to return. Defaults to 1.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the ResponseType input for this Choreo. 

		@param String - (optional, string) Output returned can be XML or JSON. Defaults to JSON.
		*/
		public void set_ResponseType(String value) {
			this.setInput("ResponseType", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetLenders Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetLendersResultSet extends ResultSet {
		public GetLendersResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Kiva.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
