package com.temboo.Library.Instagram;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SearchMedia

Allows you to search for media in a given area.
*/
public class SearchMedia extends Choreography {

	/**
	Create a new instance of the SearchMedia Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SearchMedia(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Instagram/SearchMedia"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SearchMediaInputSet
	*/
	public SearchMediaInputSet newInputSet() {
		return new SearchMediaInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SearchMediaResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SearchMediaResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SearchMedia
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SearchMediaInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (conditional, string) The access token retrieved during the OAuth 2.0 process. Required unless you provide the ClientID.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Instagram after registering your application. Required unless you provide the AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the Distance input for this Choreo. 

		@param Integer - (optional, integer) The distance in meters. Defaults to 1000. Max is 5000.
		*/
		public void set_Distance(Integer value) {
			this.setInput("Distance", value);
		}

		/** 
		Set the value of the Distance input for this Choreo as a String. 

		@param String - (optional, integer) The distance in meters. Defaults to 1000. Max is 5000.
		*/
		public void set_Distance(String value) {
			this.setInput("Distance", value);	
		}
		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (required, decimal) Latitude of the center search coordinate.
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (required, decimal) Latitude of the center search coordinate.
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (required, decimal) Longitude of the center search coordinate.
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (required, decimal) Longitude of the center search coordinate.
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the MaxTimestamp input for this Choreo. 

		@param String - (optional, date) A unix timestamp. All media returned will be taken earlier than this timestamp.
		*/
		public void set_MaxTimestamp(String value) {
			this.setInput("MaxTimestamp", value);
		}


		/** 
		Set the value of the MinTimestamp input for this Choreo. 

		@param String - (optional, date) A unix timestamp. All media returned will be taken later than this timestamp.
		*/
		public void set_MinTimestamp(String value) {
			this.setInput("MinTimestamp", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SearchMedia Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SearchMediaResultSet extends ResultSet {
		public SearchMediaResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Instagram.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
