package com.temboo.Library.Genability.TariffData;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetTimeOfUseGroupIntervals

Returns all the Intervals for a Time of Use Group within a given date range.
*/
public class GetTimeOfUseGroupIntervals extends Choreography {

	/**
	Create a new instance of the GetTimeOfUseGroupIntervals Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetTimeOfUseGroupIntervals(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Genability/TariffData/GetTimeOfUseGroupIntervals"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetTimeOfUseGroupIntervalsInputSet
	*/
	public GetTimeOfUseGroupIntervalsInputSet newInputSet() {
		return new GetTimeOfUseGroupIntervalsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetTimeOfUseGroupIntervalsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetTimeOfUseGroupIntervalsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetTimeOfUseGroupIntervals
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetTimeOfUseGroupIntervalsInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (required, string) The App ID provided by Genability.
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the AppKey input for this Choreo. 

		@param String - (required, string) The App Key provided by Genability.
		*/
		public void set_AppKey(String value) {
			this.setInput("AppKey", value);
		}


		/** 
		Set the value of the FromDateTime input for this Choreo. 

		@param String - (optional, date) The starting date and time of the requested Intervals (in ISO 8601 format). Defaults to current date if not specified.
		*/
		public void set_FromDateTime(String value) {
			this.setInput("FromDateTime", value);
		}


		/** 
		Set the value of the LSEID input for this Choreo. 

		@param Integer - (required, integer) Used to retrieve a TOU Group for a specific LSE.
		*/
		public void set_LSEID(Integer value) {
			this.setInput("LSEID", value);
		}

		/** 
		Set the value of the LSEID input for this Choreo as a String. 

		@param String - (required, integer) Used to retrieve a TOU Group for a specific LSE.
		*/
		public void set_LSEID(String value) {
			this.setInput("LSEID", value);	
		}
		/** 
		Set the value of the PageCount input for this Choreo. 

		@param Integer - (optional, integer) The number of results to return. Defaults to 25.
		*/
		public void set_PageCount(Integer value) {
			this.setInput("PageCount", value);
		}

		/** 
		Set the value of the PageCount input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to return. Defaults to 25.
		*/
		public void set_PageCount(String value) {
			this.setInput("PageCount", value);	
		}
		/** 
		Set the value of the PageStart input for this Choreo. 

		@param Integer - (optional, integer) The page number to begin the result set from. Defaults to 1.
		*/
		public void set_PageStart(Integer value) {
			this.setInput("PageStart", value);
		}

		/** 
		Set the value of the PageStart input for this Choreo as a String. 

		@param String - (optional, integer) The page number to begin the result set from. Defaults to 1.
		*/
		public void set_PageStart(String value) {
			this.setInput("PageStart", value);	
		}
		/** 
		Set the value of the TOUGroupID input for this Choreo. 

		@param Integer - (required, integer) Used to retrieve a TOU Group by its ID.
		*/
		public void set_TOUGroupID(Integer value) {
			this.setInput("TOUGroupID", value);
		}

		/** 
		Set the value of the TOUGroupID input for this Choreo as a String. 

		@param String - (required, integer) Used to retrieve a TOU Group by its ID.
		*/
		public void set_TOUGroupID(String value) {
			this.setInput("TOUGroupID", value);	
		}
		/** 
		Set the value of the ToDateTime input for this Choreo. 

		@param String - (optional, date) The ending date and time of the requested Intervals (in ISO 8601 format). If not specified, defaults to one week ahead of the current date.
		*/
		public void set_ToDateTime(String value) {
			this.setInput("ToDateTime", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetTimeOfUseGroupIntervals Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetTimeOfUseGroupIntervalsResultSet extends ResultSet {
		public GetTimeOfUseGroupIntervalsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Genability.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
