package com.temboo.Library.FilesAnywhere;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
DeleteItem

Deletes a file from a specified directory in your FilesAnywhere account.
*/
public class DeleteItem extends Choreography {

	/**
	Create a new instance of the DeleteItem Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public DeleteItem(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/FilesAnywhere/DeleteItem"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return DeleteItemInputSet
	*/
	public DeleteItemInputSet newInputSet() {
		return new DeleteItemInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public DeleteItemResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new DeleteItemResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the DeleteItem
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class DeleteItemInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (conditional, string) The API Key provided by FilesAnywhere. Required unless supplying a valid Token input.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the OrgID input for this Choreo. 

		@param Integer - (conditional, integer) Defaults to 0 for a FilesAnywhere Web account.  Use 50 for a FilesAnywhere WebAdvanced account.
		*/
		public void set_OrgID(Integer value) {
			this.setInput("OrgID", value);
		}

		/** 
		Set the value of the OrgID input for this Choreo as a String. 

		@param String - (conditional, integer) Defaults to 0 for a FilesAnywhere Web account.  Use 50 for a FilesAnywhere WebAdvanced account.
		*/
		public void set_OrgID(String value) {
			this.setInput("OrgID", value);	
		}
		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (conditional, password) Your FilesAnywhere password. Required unless supplying a valid Token input.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Path input for this Choreo. 

		@param String - (required, string) The path to the file you want to delete (i.e. \JOHNSMITH\MyFolder\MyFile.txt).
		*/
		public void set_Path(String value) {
			this.setInput("Path", value);
		}


		/** 
		Set the value of the Token input for this Choreo. 

		@param String - (conditional, string) If provided, the Choreo will use the token to authenticate. If the token is expired or not provided, the Choreo will relogin and retrieve a new token when APIKey, Username, and Password are supplied.
		*/
		public void set_Token(String value) {
			this.setInput("Token", value);
		}


		/** 
		Set the value of the Type input for this Choreo. 

		@param String - (optional, string) The type of item you are deleting. Can be set to 'file' or 'folder'. Defaults to 'file'.
		*/
		public void set_Type(String value) {
			this.setInput("Type", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (conditional, string) Your FilesAnywhere username. Required unless supplying a valid Token input.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the DeleteItem Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class DeleteItemResultSet extends ResultSet {
		public DeleteItemResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Token" output from this Choreo execution

		@return String - (conditional, string) If provided, the Choreo will use the token to authenticate. If the token is expired or not provided, the Choreo will relogin and retrieve a new token when APIKey, Username, and Password are supplied.
		*/
		public String get_Token() {
			return this.getResultString("Token");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from FilesAnywhere.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
