package com.temboo.Library.CloudMine.ObjectStorage;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ObjectGet

Retrieves one or more objects from Cloudmine.
*/
public class ObjectGet extends Choreography {

	/**
	Create a new instance of the ObjectGet Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ObjectGet(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/CloudMine/ObjectStorage/ObjectGet"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ObjectGetInputSet
	*/
	public ObjectGetInputSet newInputSet() {
		return new ObjectGetInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ObjectGetResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ObjectGetResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ObjectGet
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ObjectGetInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by CloudMine after registering your app.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the ApplicationIdentifier input for this Choreo. 

		@param String - (required, string) The application identifier provided by CloudMine after registering your app.
		*/
		public void set_ApplicationIdentifier(String value) {
			this.setInput("ApplicationIdentifier", value);
		}


		/** 
		Set the value of the Count input for this Choreo. 

		@param Boolean - (optional, boolean) Returns a count of the results in the response if set to true. Valid values are true and false.
		*/
		public void set_Count(Boolean value) {
			this.setInput("Count", value);
		}

		/** 
		Set the value of the Count input for this Choreo as a String. 

		@param String - (optional, boolean) Returns a count of the results in the response if set to true. Valid values are true and false.
		*/
		public void set_Count(String value) {
			this.setInput("Count", value);	
		}
		/** 
		Set the value of the Keys input for this Choreo. 

		@param String - (optional, string) A comma separated list of keys to return. If not specified, all key/value pairs are returned.
		*/
		public void set_Keys(String value) {
			this.setInput("Keys", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) Limits the number of results returned. Use -1 for no limit. Use 0 for no results, and with Count=true to just get the number of available results. This defaults to 50.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) Limits the number of results returned. Use -1 for no limit. Use 0 for no results, and with Count=true to just get the number of available results. This defaults to 50.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the SessionToken input for this Choreo. 

		@param String - (conditional, string) The session token for an existing user (returned by the AccountLogin Choreo). This is only required if your app is performing this operation on behalf of another user.
		*/
		public void set_SessionToken(String value) {
			this.setInput("SessionToken", value);
		}


		/** 
		Set the value of the Skip input for this Choreo. 

		@param Integer - (optional, integer) Indicates to start results after skiping this number objects. Used to page through results.
		*/
		public void set_Skip(Integer value) {
			this.setInput("Skip", value);
		}

		/** 
		Set the value of the Skip input for this Choreo as a String. 

		@param String - (optional, integer) Indicates to start results after skiping this number objects. Used to page through results.
		*/
		public void set_Skip(String value) {
			this.setInput("Skip", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ObjectGet Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ObjectGetResultSet extends ResultSet {
		public ObjectGetResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from CloudMine.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
