package com.temboo.Library.Bugzilla;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListBugHistory

Retrieves detailed history for a specified bug.
*/
public class ListBugHistory extends Choreography {

	/**
	Create a new instance of the ListBugHistory Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListBugHistory(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Bugzilla/ListBugHistory"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListBugHistoryInputSet
	*/
	public ListBugHistoryInputSet newInputSet() {
		return new ListBugHistoryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListBugHistoryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListBugHistoryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListBugHistory
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListBugHistoryInputSet extends InputSet {
		/** 
		Set the value of the BugID input for this Choreo. 

		@param Integer - (required, integer) The ID for the bug to retrieve history information for.
		*/
		public void set_BugID(Integer value) {
			this.setInput("BugID", value);
		}

		/** 
		Set the value of the BugID input for this Choreo as a String. 

		@param String - (required, integer) The ID for the bug to retrieve history information for.
		*/
		public void set_BugID(String value) {
			this.setInput("BugID", value);	
		}
		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (optional, password) Your Bugzilla password.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Server input for this Choreo. 

		@param String - (optional, string) The base URL for the Bugzilla server to access. Defaults to https://api-dev.bugzilla.mozilla.org/latest. To access the test server, set to https://api-dev.bugzilla.mozilla.org/test/latest.
		*/
		public void set_Server(String value) {
			this.setInput("Server", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (optional, string) Your Bugzilla username.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListBugHistory Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListBugHistoryResultSet extends ResultSet {
		public ListBugHistoryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Bugzilla.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
