package com.temboo.Library.Amazon.S3;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ZipBucket

Creates a zip file containing all objects within the specified bucket and returns a download link for the new compressed file.
*/
public class ZipBucket extends Choreography {

	/**
	Create a new instance of the ZipBucket Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ZipBucket(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/S3/ZipBucket"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ZipBucketInputSet
	*/
	public ZipBucketInputSet newInputSet() {
		return new ZipBucketInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ZipBucketResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ZipBucketResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ZipBucket
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ZipBucketInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the BucketName input for this Choreo. 

		@param String - (required, string) The name of the bucket that contains the list of objects that you want to zip.
		*/
		public void set_BucketName(String value) {
			this.setInput("BucketName", value);
		}


		/** 
		Set the value of the CannedACL input for this Choreo. 

		@param String - (conditional, string) This sets the permissions for the newly created zip file. Valid values are: private, public-read, public-read-write, authenticated-read, bucket-owner-read, or bucket-owner-full-control.
		*/
		public void set_CannedACL(String value) {
			this.setInput("CannedACL", value);
		}


		/** 
		Set the value of the Delimiter input for this Choreo. 

		@param String - (optional, string) A delimiter is a character you use to group keys. All keys that contain the delimiter are grouped under a single result element, Common Prefixes. For more information see Amazon documentation.
		*/
		public void set_Delimiter(String value) {
			this.setInput("Delimiter", value);
		}


		/** 
		Set the value of the Prefix input for this Choreo. 

		@param String - (optional, string) Limits the response to keys that begin with the specified prefix - useful for separating a bucket into different groupings of keys. Ex: specify 'test' to get a list of objects starting with 'test'.
		*/
		public void set_Prefix(String value) {
			this.setInput("Prefix", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (required, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


		/** 
		Set the value of the ZipFileLocation input for this Choreo. 

		@param String - (optional, string) The name of the bucket to put the new zip file in. When not specified, the zip file will be put in the bucket that contains the files being zipped.
		*/
		public void set_ZipFileLocation(String value) {
			this.setInput("ZipFileLocation", value);
		}


		/** 
		Set the value of the ZipFileName input for this Choreo. 

		@param String - (optional, string) The name of the zip file that will be created. If not specified, the original bucket name will be used with .zip extension.
		*/
		public void set_ZipFileName(String value) {
			this.setInput("ZipFileName", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ZipBucket Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ZipBucketResultSet extends ResultSet {
		public ZipBucketResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "URL" output from this Choreo execution

		@return String - (string) The URL location of the new zip file.
		*/
		public String get_URL() {
			return this.getResultString("URL");
		}
	}
	
}
