package com.temboo.Library.Amazon.S3;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CopyObject

Makes a copy of an existing object in S3 Storage.
*/
public class CopyObject extends Choreography {

	/**
	Create a new instance of the CopyObject Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CopyObject(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Amazon/S3/CopyObject"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CopyObjectInputSet
	*/
	public CopyObjectInputSet newInputSet() {
		return new CopyObjectInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CopyObjectResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CopyObjectResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CopyObject
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CopyObjectInputSet extends InputSet {
		/** 
		Set the value of the AWSAccessKeyId input for this Choreo. 

		@param String - (required, string) The Access Key ID provided by Amazon Web Services.
		*/
		public void set_AWSAccessKeyId(String value) {
			this.setInput("AWSAccessKeyId", value);
		}


		/** 
		Set the value of the AWSSecretKeyId input for this Choreo. 

		@param String - (required, string) The Secret Key ID provided by Amazon Web Services.
		*/
		public void set_AWSSecretKeyId(String value) {
			this.setInput("AWSSecretKeyId", value);
		}


		/** 
		Set the value of the BucketName input for this Choreo. 

		@param String - (required, string) The name of the bucket that will be the file destination.
		*/
		public void set_BucketName(String value) {
			this.setInput("BucketName", value);
		}


		/** 
		Set the value of the CannedACL input for this Choreo. 

		@param String - (optional, string) By default all objects are private (only owner has full access control). Valid values: private, public-read, public-read-write, authenticated-read, bucket-owner-read, bucket-owner-full-control.
		*/
		public void set_CannedACL(String value) {
			this.setInput("CannedACL", value);
		}


		/** 
		Set the value of the ContentType input for this Choreo. 

		@param String - (optional, string) ContentType. Default is application/octet-stream.
		*/
		public void set_ContentType(String value) {
			this.setInput("ContentType", value);
		}


		/** 
		Set the value of the FileToCopy input for this Choreo. 

		@param String - (required, string) The name of the file to copy.
		*/
		public void set_FileToCopy(String value) {
			this.setInput("FileToCopy", value);
		}


		/** 
		Set the value of the IfMatch input for this Choreo. 

		@param String - (optional, string) Copies the object if its entity tag (ETag) matches the specified tag; otherwise returns a 412 HTTP status code error (failed precondition).
		*/
		public void set_IfMatch(String value) {
			this.setInput("IfMatch", value);
		}


		/** 
		Set the value of the IfModifiedSince input for this Choreo. 

		@param String - (optional, date) Copies if it has been modified since the specified time; otherwise returns a 412 HTTP status code error (failed precondition). Must be valid HTTP date. Can be used with IfMatch only.
		*/
		public void set_IfModifiedSince(String value) {
			this.setInput("IfModifiedSince", value);
		}


		/** 
		Set the value of the IfNoneMatch input for this Choreo. 

		@param String - (optional, string) Copies the object if its entity tag (ETag) is different from the specified tag; otherwise returns a 412 HTTP status code error (failed precondition).
		*/
		public void set_IfNoneMatch(String value) {
			this.setInput("IfNoneMatch", value);
		}


		/** 
		Set the value of the IfUnmodifiedSince input for this Choreo. 

		@param String - (optional, date) Copies if it hasn't been modified since the specified time; otherwise returns a 412 HTTP status code error (failed precondition). Must be valid HTTP date. Can be used with IfMatch or IfNoneMatch only.
		*/
		public void set_IfUnmodifiedSince(String value) {
			this.setInput("IfUnmodifiedSince", value);
		}


		/** 
		Set the value of the NewFileName input for this Choreo. 

		@param String - (required, string) The file name for the new copy.
		*/
		public void set_NewFileName(String value) {
			this.setInput("NewFileName", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "xml" (the default) and "json".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SSECAlgorithm input for this Choreo. 

		@param String - (optional, string) Specifies the server-side encryption with customer-provided encryption keys (SSE-C) algorithm to use when Amazon S3 creates the target object. Valid value: AES256.
		*/
		public void set_SSECAlgorithm(String value) {
			this.setInput("SSECAlgorithm", value);
		}


		/** 
		Set the value of the SSECKey input for this Choreo. 

		@param String - (optional, string) The customer-provided AES-256 256-bit (32-byte) encryption key for Amazon S3 to use to encrypt or decrypt your copied data object.
		*/
		public void set_SSECKey(String value) {
			this.setInput("SSECKey", value);
		}


		/** 
		Set the value of the SSECSourceAlgorithm input for this Choreo. 

		@param String - (optional, string) Specifies the server-side encryption with customer-provided encryption keys (SSE-C) algorithm to use to decrypt the Amazon S3 source object being copied. Valid value: AES256.
		*/
		public void set_SSECSourceAlgorithm(String value) {
			this.setInput("SSECSourceAlgorithm", value);
		}


		/** 
		Set the value of the SSECSourceKey input for this Choreo. 

		@param String - (optional, string) The customer-provided AES-256 256-bit (32-byte) encryption key for Amazon S3 to use to decrypt the copy source object.
		*/
		public void set_SSECSourceKey(String value) {
			this.setInput("SSECSourceKey", value);
		}


		/** 
		Set the value of the ServerSideEncryption input for this Choreo. 

		@param String - (optional, string) Specifies the server-side encryption algorithm to use when Amazon S3 creates the target object. Valid value: AES256.
		*/
		public void set_ServerSideEncryption(String value) {
			this.setInput("ServerSideEncryption", value);
		}


		/** 
		Set the value of the StorageClass input for this Choreo. 

		@param String - (optional, string) Enables RRS customers to store their noncritical, reproducible data at lower levels of redundancy than Amazon S3's standard storage. Valid Values: STANDARD (default), REDUCED_REDUNDANCY.
		*/
		public void set_StorageClass(String value) {
			this.setInput("StorageClass", value);
		}


		/** 
		Set the value of the UserRegion input for this Choreo. 

		@param String - (required, string) The AWS region that corresponds to the S3 endpoint you wish to access. The default region is "us-east-1".
		*/
		public void set_UserRegion(String value) {
			this.setInput("UserRegion", value);
		}


		/** 
		Set the value of the WebsiteRedirectLocation input for this Choreo. 

		@param String - (optional, string) If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Ex: /anotherPage.html, http://www.page.com. Length limit: 2 K.
		*/
		public void set_WebsiteRedirectLocation(String value) {
			this.setInput("WebsiteRedirectLocation", value);
		}


		/** 
		Set the value of the VaultFile input for this Choreo. 

		@param TembooPath - (optional, vault file) The path to a vault file that you want to upload to an Amazon S3 bucket. Required unless using the FileContents input variable.
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CopyObject Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CopyObjectResultSet extends ResultSet {
		public CopyObjectResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Amazon.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
