package com.temboo.Library.Zillow;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetComps

Returns a list of comparable recent sales for a specified property.
*/
public class GetComps extends Choreography {

	/**
	Create a new instance of the GetComps Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetComps(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Zillow/GetComps"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetCompsInputSet
	*/
	public GetCompsInputSet newInputSet() {
		return new GetCompsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetCompsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetCompsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetComps
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetCompsInputSet extends InputSet {
		/** 
		Set the value of the Count input for this Choreo. 

		@param Integer - (required, integer) Enter the number of comparable recent sales to retrieve. Choose a value between 1 and 25.
		*/
		public void set_Count(Integer value) {
			this.setInput("Count", value);
		}

		/** 
		Set the value of the Count input for this Choreo as a String. 

		@param String - (required, integer) Enter the number of comparable recent sales to retrieve. Choose a value between 1 and 25.
		*/
		public void set_Count(String value) {
			this.setInput("Count", value);	
		}
		/** 
		Set the value of the RentEstimate input for this Choreo. 

		@param Boolean - (optional, boolean) Set to 1 (true) to enable. Defaults to 0 (false).
		*/
		public void set_RentEstimate(Boolean value) {
			this.setInput("RentEstimate", value);
		}

		/** 
		Set the value of the RentEstimate input for this Choreo as a String. 

		@param String - (optional, boolean) Set to 1 (true) to enable. Defaults to 0 (false).
		*/
		public void set_RentEstimate(String value) {
			this.setInput("RentEstimate", value);	
		}
		/** 
		Set the value of the ZPID input for this Choreo. 

		@param Integer - (required, integer) Enter a Zillow Property ID for the property being queried.
		*/
		public void set_ZPID(Integer value) {
			this.setInput("ZPID", value);
		}

		/** 
		Set the value of the ZPID input for this Choreo as a String. 

		@param String - (required, integer) Enter a Zillow Property ID for the property being queried.
		*/
		public void set_ZPID(String value) {
			this.setInput("ZPID", value);	
		}
		/** 
		Set the value of the ZWSID input for this Choreo. 

		@param String - (required, string) Enter a Zillow Web Service Identifier (ZWS ID).
		*/
		public void set_ZWSID(String value) {
			this.setInput("ZWSID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetComps Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetCompsResultSet extends ResultSet {
		public GetCompsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Zillow.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
