package com.temboo.Library.Zendesk.Users;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
UpdateUserImage

Updates a user's profile image.
*/
public class UpdateUserImage extends Choreography {

	/**
	Create a new instance of the UpdateUserImage Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public UpdateUserImage(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Zendesk/Users/UpdateUserImage"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return UpdateUserImageInputSet
	*/
	public UpdateUserImageInputSet newInputSet() {
		return new UpdateUserImageInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public UpdateUserImageResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new UpdateUserImageResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the UpdateUserImage
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class UpdateUserImageInputSet extends InputSet {
		/** 
		Set the value of the Response input for this Choreo. 

		@param String - (required, json) The response from Zendesk.
		*/
		public void set_Response(String value) {
			this.setInput("Response", value);
		}


		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (required, string) The email address you use to login to your Zendesk account.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the ImageURL input for this Choreo. 

		@param String - (required, string) The URL of the profile image.
		*/
		public void set_ImageURL(String value) {
			this.setInput("ImageURL", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) Your Zendesk password.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Server input for this Choreo. 

		@param String - (required, string) Your Zendesk domain and subdomain (e.g., temboocare.zendesk.com).
		*/
		public void set_Server(String value) {
			this.setInput("Server", value);
		}


		/** 
		Set the value of the UserID input for this Choreo. 

		@param Integer - (required, integer) The ID of the user being updated.
		*/
		public void set_UserID(Integer value) {
			this.setInput("UserID", value);
		}

		/** 
		Set the value of the UserID input for this Choreo as a String. 

		@param String - (required, integer) The ID of the user being updated.
		*/
		public void set_UserID(String value) {
			this.setInput("UserID", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the UpdateUserImage Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class UpdateUserImageResultSet extends ResultSet {
		public UpdateUserImageResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (required, json) The response from Zendesk.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
