package com.temboo.Library.Zendesk.Organizations;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetOrganization

Get detailed info for a given organization.
*/
public class GetOrganization extends Choreography {

	/**
	Create a new instance of the GetOrganization Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetOrganization(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Zendesk/Organizations/GetOrganization"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetOrganizationInputSet
	*/
	public GetOrganizationInputSet newInputSet() {
		return new GetOrganizationInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetOrganizationResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetOrganizationResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetOrganization
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetOrganizationInputSet extends InputSet {
		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (required, string) The email address you use to login to your Zendesk account.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the ID input for this Choreo. 

		@param String - (required, string) ID of the organization to get.
		*/
		public void set_ID(String value) {
			this.setInput("ID", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) Your Zendesk password.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Server input for this Choreo. 

		@param String - (required, string) Your Zendesk domain and subdomain (e.g., temboocare.zendesk.com).
		*/
		public void set_Server(String value) {
			this.setInput("Server", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetOrganization Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetOrganizationResultSet extends ResultSet {
		public GetOrganizationResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Zendesk.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
