package com.temboo.Library.Zendesk.IncrementalTickets;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ExportIncrementalTickets

Returns a lightweight representation of what changed in the ticket "since you last asked".
*/
public class ExportIncrementalTickets extends Choreography {

	/**
	Create a new instance of the ExportIncrementalTickets Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ExportIncrementalTickets(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Zendesk/IncrementalTickets/ExportIncrementalTickets"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ExportIncrementalTicketsInputSet
	*/
	public ExportIncrementalTicketsInputSet newInputSet() {
		return new ExportIncrementalTicketsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ExportIncrementalTicketsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ExportIncrementalTicketsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ExportIncrementalTickets
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ExportIncrementalTicketsInputSet extends InputSet {
		/** 
		Set the value of the Email input for this Choreo. 

		@param String - (required, string) The email address you use to login to your Zendesk account.
		*/
		public void set_Email(String value) {
			this.setInput("Email", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) Your Zendesk password.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the Server input for this Choreo. 

		@param String - (required, string) Your Zendesk domain and subdomain (e.g., temboocare.zendesk.com).
		*/
		public void set_Server(String value) {
			this.setInput("Server", value);
		}


		/** 
		Set the value of the StartTime input for this Choreo. 

		@param String - (required, string) Return a list of tickets created after this timestamp (in seconds since Epoch UTC).  Tickets less than 5 minutes old are not included in the response.
		*/
		public void set_StartTime(String value) {
			this.setInput("StartTime", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ExportIncrementalTickets Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ExportIncrementalTicketsResultSet extends ResultSet {
		public ExportIncrementalTicketsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Zendesk.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
