package com.temboo.Library.Xively.ReadWriteData;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListAllFeeds

Returns filterable data on all feeds viewable by the authenticated account.
*/
public class ListAllFeeds extends Choreography {

	/**
	Create a new instance of the ListAllFeeds Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListAllFeeds(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Xively/ReadWriteData/ListAllFeeds"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListAllFeedsInputSet
	*/
	public ListAllFeedsInputSet newInputSet() {
		return new ListAllFeedsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListAllFeedsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListAllFeedsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListAllFeeds
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListAllFeedsInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by Xively.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Content input for this Choreo. 

		@param String - (optional, string) Describes whether to return full or summary results. Full - all datastream values are returned, summary - returns the environment metadata for each feed. Valid values: 'full' or 'summary'.
		*/
		public void set_Content(String value) {
			this.setInput("Content", value);
		}


		/** 
		Set the value of the Distance input for this Choreo. 

		@param BigDecimal - (optional, decimal) Search radius (units like miles or kilometers defined by DistanceUnits). Ex: 5.0.
		*/
		public void set_Distance(BigDecimal value) {
			this.setInput("Distance", value);
		}

		/** 
		Set the value of the Distance input for this Choreo as a String. 

		@param String - (optional, decimal) Search radius (units like miles or kilometers defined by DistanceUnits). Ex: 5.0.
		*/
		public void set_Distance(String value) {
			this.setInput("Distance", value);	
		}
		/** 
		Set the value of the DistanceUnits input for this Choreo. 

		@param String - (optional, string) Units of distance. Valid values: "miles" or "kms" (default).
		*/
		public void set_DistanceUnits(String value) {
			this.setInput("DistanceUnits", value);
		}


		/** 
		Set the value of the FeedType input for this Choreo. 

		@param String - (optional, string) The type of feed that is being returned. Valid values are "json" (the default), "xml" and "csv". No metadata is returned for the csv feed.
		*/
		public void set_FeedType(String value) {
			this.setInput("FeedType", value);
		}


		/** 
		Set the value of the FullTextSearch input for this Choreo. 

		@param String - (optional, string) Returns any feeds matching this string.
		*/
		public void set_FullTextSearch(String value) {
			this.setInput("FullTextSearch", value);
		}


		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (optional, decimal) Used to find feeds located around this latitude. Ex. 51.5235375648154.
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (optional, decimal) Used to find feeds located around this latitude. Ex. 51.5235375648154.
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (optional, decimal) Used to find feeds located around this longitude. Ex: -0.0807666778564453.
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (optional, decimal) Used to find feeds located around this longitude. Ex: -0.0807666778564453.
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) Indicates which page of results you are requesting. Starts from 1.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) Indicates which page of results you are requesting. Starts from 1.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the PerPage input for this Choreo. 

		@param Integer - (optional, integer) Defines how many results to return per page (1 to 1000).
		*/
		public void set_PerPage(Integer value) {
			this.setInput("PerPage", value);
		}

		/** 
		Set the value of the PerPage input for this Choreo as a String. 

		@param String - (optional, integer) Defines how many results to return per page (1 to 1000).
		*/
		public void set_PerPage(String value) {
			this.setInput("PerPage", value);	
		}
		/** 
		Set the value of the ShowUser input for this Choreo. 

		@param String - (optional, string) Include user login and user level for each feed. Valid values: true, false (default).
		*/
		public void set_ShowUser(String value) {
			this.setInput("ShowUser", value);
		}


		/** 
		Set the value of the SortOrder input for this Choreo. 

		@param String - (optional, string) Order of returned feeds. Valid values: "created_at", "retrieved_at" or "relevance".
		*/
		public void set_SortOrder(String value) {
			this.setInput("SortOrder", value);
		}


		/** 
		Set the value of the Status input for this Choreo. 

		@param String - (optional, string) Sets whether to search for only live feeds, only frozen feeds, or all feeds. Valid values: "live", "frozen", "all" (default).
		*/
		public void set_Status(String value) {
			this.setInput("Status", value);
		}


		/** 
		Set the value of the Tag input for this Choreo. 

		@param String - (optional, string) Returns feeds containing datastreams tagged with the search query.
		*/
		public void set_Tag(String value) {
			this.setInput("Tag", value);
		}


		/** 
		Set the value of the Units input for this Choreo. 

		@param String - (optional, string) Returns feeds containing datastreams with units specified by the search query. Ex: Celsius.
		*/
		public void set_Units(String value) {
			this.setInput("Units", value);
		}


		/** 
		Set the value of the User input for this Choreo. 

		@param String - (optional, string) Returns feeds created by the user specified.
		*/
		public void set_User(String value) {
			this.setInput("User", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListAllFeeds Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListAllFeedsResultSet extends ResultSet {
		public ListAllFeedsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Xively.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
