package com.temboo.Library.Wikipedia;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetPageSummary

Retrieves a summary response including a text extract of the first several sentences, as well as information about a thumbnail that represents the page.
*/
public class GetPageSummary extends Choreography {

	/**
	Create a new instance of the GetPageSummary Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetPageSummary(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Wikipedia/GetPageSummary"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetPageSummaryInputSet
	*/
	public GetPageSummaryInputSet newInputSet() {
		return new GetPageSummaryInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetPageSummaryResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetPageSummaryResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetPageSummary
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetPageSummaryInputSet extends InputSet {
		/** 
		Set the value of the Title input for this Choreo. 

		@param String - (required, string) The Wikipedia page title.
		*/
		public void set_Title(String value) {
			this.setInput("Title", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetPageSummary Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetPageSummaryResultSet extends ResultSet {
		public GetPageSummaryResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Extract" output from this Choreo execution

		@return String - (string) The page summary.
		*/
		public String get_Extract() {
			return this.getResultString("Extract");
		}
		/** 
		Retrieve the value for the "ResponseCode" output from this Choreo execution

		@return String - (integer) The response code returned by the API.
		*/
		public String get_ResponseCode() {
			return this.getResultString("ResponseCode");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Wikipedia.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
