package com.temboo.Library.Utilities.TokenStorage;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
StoreToken

Stores a token.
*/
public class StoreToken extends Choreography {

	/**
	Create a new instance of the StoreToken Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public StoreToken(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/TokenStorage/StoreToken"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return StoreTokenInputSet
	*/
	public StoreTokenInputSet newInputSet() {
		return new StoreTokenInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public StoreTokenResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new StoreTokenResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the StoreToken
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class StoreTokenInputSet extends InputSet {
		/** 
		Set the value of the Expires input for this Choreo. 

		@param Integer - (optional, integer) The lifetime of the token (in seconds). Defaults to 0 indicating no expiration.
		*/
		public void set_Expires(Integer value) {
			this.setInput("Expires", value);
		}

		/** 
		Set the value of the Expires input for this Choreo as a String. 

		@param String - (optional, integer) The lifetime of the token (in seconds). Defaults to 0 indicating no expiration.
		*/
		public void set_Expires(String value) {
			this.setInput("Expires", value);	
		}
		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (required, string) The token name. When a token does not exist, it will be inserted. When a token does exist, an update is performed.
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


		/** 
		Set the value of the Value input for this Choreo. 

		@param String - (required, string) The token value to store. The maximum number of characters for a token is 4096.
		*/
		public void set_Value(String value) {
			this.setInput("Value", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the StoreToken Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class StoreTokenResultSet extends ResultSet {
		public StoreTokenResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Updated" output from this Choreo execution

		@return String - (boolean) Returns true if token is stored successfully.
		*/
		public String get_Updated() {
			return this.getResultString("Updated");
		}
	}
	
}
