package com.temboo.Library.Utilities.TokenStorage;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
IsLocked

Returns true or false depending on whether the token is locked or not.
*/
public class IsLocked extends Choreography {

	/**
	Create a new instance of the IsLocked Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public IsLocked(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/TokenStorage/IsLocked"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return IsLockedInputSet
	*/
	public IsLockedInputSet newInputSet() {
		return new IsLockedInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public IsLockedResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new IsLockedResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the IsLocked
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class IsLockedInputSet extends InputSet {
		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (required, string) The name of the token to check.
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the IsLocked Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class IsLockedResultSet extends ResultSet {
		public IsLockedResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Locked" output from this Choreo execution

		@return String - (boolean) Returns true or false depending on whether the token is locked or not.
		*/
		public String get_Locked() {
			return this.getResultString("Locked");
		}
	}
	
}
