package com.temboo.Library.Utilities.Encoding;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
HTMLUnescape

Replaces character entity names in the specified text with equivalent HTML markup characters.
*/
public class HTMLUnescape extends Choreography {

	/**
	Create a new instance of the HTMLUnescape Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public HTMLUnescape(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/Encoding/HTMLUnescape"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return HTMLUnescapeInputSet
	*/
	public HTMLUnescapeInputSet newInputSet() {
		return new HTMLUnescapeInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public HTMLUnescapeResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new HTMLUnescapeResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the HTMLUnescape
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class HTMLUnescapeInputSet extends InputSet {
		/** 
		Set the value of the EscapedHTML input for this Choreo. 

		@param String - (required, string) The escaped HTML that should be unescaped.
		*/
		public void set_EscapedHTML(String value) {
			this.setInput("EscapedHTML", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the HTMLUnescape Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class HTMLUnescapeResultSet extends ResultSet {
		public HTMLUnescapeResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "UnescapedHTML" output from this Choreo execution

		@return String - (string) The unescaped HTML.
		*/
		public String get_UnescapedHTML() {
			return this.getResultString("UnescapedHTML");
		}
	}
	
}
