package com.temboo.Library.Utilities.Dates;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetTimestampFromDateParameters

Returns the specified date parameters, expressed as the number of seconds or milliseconds since January 1, 1970 (epoch time).
*/
public class GetTimestampFromDateParameters extends Choreography {

	/**
	Create a new instance of the GetTimestampFromDateParameters Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetTimestampFromDateParameters(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Utilities/Dates/GetTimestampFromDateParameters"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetTimestampFromDateParametersInputSet
	*/
	public GetTimestampFromDateParametersInputSet newInputSet() {
		return new GetTimestampFromDateParametersInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetTimestampFromDateParametersResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetTimestampFromDateParametersResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetTimestampFromDateParameters
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetTimestampFromDateParametersInputSet extends InputSet {
		/** 
		Set the value of the Day input for this Choreo. 

		@param Integer - (conditional, integer) Sets the day (1-31) of the timestamp.
		*/
		public void set_Day(Integer value) {
			this.setInput("Day", value);
		}

		/** 
		Set the value of the Day input for this Choreo as a String. 

		@param String - (conditional, integer) Sets the day (1-31) of the timestamp.
		*/
		public void set_Day(String value) {
			this.setInput("Day", value);	
		}
		/** 
		Set the value of the Granularity input for this Choreo. 

		@param String - (optional, string) Set to "seconds" to return the number of seconds since the epoch. Defaults to "milliseconds".
		*/
		public void set_Granularity(String value) {
			this.setInput("Granularity", value);
		}


		/** 
		Set the value of the Hour input for this Choreo. 

		@param Integer - (optional, integer) Sets the hours (0-23) of the timestamp.
		*/
		public void set_Hour(Integer value) {
			this.setInput("Hour", value);
		}

		/** 
		Set the value of the Hour input for this Choreo as a String. 

		@param String - (optional, integer) Sets the hours (0-23) of the timestamp.
		*/
		public void set_Hour(String value) {
			this.setInput("Hour", value);	
		}
		/** 
		Set the value of the Milliseconds input for this Choreo. 

		@param Integer - (optional, integer) Sets the milliseconds (0-999) of the timestamp.
		*/
		public void set_Milliseconds(Integer value) {
			this.setInput("Milliseconds", value);
		}

		/** 
		Set the value of the Milliseconds input for this Choreo as a String. 

		@param String - (optional, integer) Sets the milliseconds (0-999) of the timestamp.
		*/
		public void set_Milliseconds(String value) {
			this.setInput("Milliseconds", value);	
		}
		/** 
		Set the value of the Minute input for this Choreo. 

		@param Integer - (optional, integer) Sets the minutes (0-59) of the timestamp.
		*/
		public void set_Minute(Integer value) {
			this.setInput("Minute", value);
		}

		/** 
		Set the value of the Minute input for this Choreo as a String. 

		@param String - (optional, integer) Sets the minutes (0-59) of the timestamp.
		*/
		public void set_Minute(String value) {
			this.setInput("Minute", value);	
		}
		/** 
		Set the value of the Month input for this Choreo. 

		@param Integer - (conditional, integer) Sets the month (1-12) of the timestamp.
		*/
		public void set_Month(Integer value) {
			this.setInput("Month", value);
		}

		/** 
		Set the value of the Month input for this Choreo as a String. 

		@param String - (conditional, integer) Sets the month (1-12) of the timestamp.
		*/
		public void set_Month(String value) {
			this.setInput("Month", value);	
		}
		/** 
		Set the value of the Second input for this Choreo. 

		@param Integer - (optional, integer) Sets the seconds (0-59) of the timestamp.
		*/
		public void set_Second(Integer value) {
			this.setInput("Second", value);
		}

		/** 
		Set the value of the Second input for this Choreo as a String. 

		@param String - (optional, integer) Sets the seconds (0-59) of the timestamp.
		*/
		public void set_Second(String value) {
			this.setInput("Second", value);	
		}
		/** 
		Set the value of the Year input for this Choreo. 

		@param Integer - (conditional, integer) Sets the year of the timestamp.
		*/
		public void set_Year(Integer value) {
			this.setInput("Year", value);
		}

		/** 
		Set the value of the Year input for this Choreo as a String. 

		@param String - (conditional, integer) Sets the year of the timestamp.
		*/
		public void set_Year(String value) {
			this.setInput("Year", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetTimestampFromDateParameters Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetTimestampFromDateParametersResultSet extends ResultSet {
		public GetTimestampFromDateParametersResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Timestamp" output from this Choreo execution

		@return String - (date) A number representing the specified date and time, expressed as the number of seconds or milliseconds since January 1, 1970. The Granularity input is used to indicate seconds or milliseconds.
		*/
		public String get_Timestamp() {
			return this.getResultString("Timestamp");
		}
	}
	
}
