package com.temboo.Library.Twilio.AvailablePhoneNumbers;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
LocalList

Returns a list of local available phone numbers that match the specified filters.
*/
public class LocalList extends Choreography {

	/**
	Create a new instance of the LocalList Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public LocalList(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Twilio/AvailablePhoneNumbers/LocalList"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return LocalListInputSet
	*/
	public LocalListInputSet newInputSet() {
		return new LocalListInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public LocalListResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new LocalListResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the LocalList
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class LocalListInputSet extends InputSet {
		/** 
		Set the value of the AccountSID input for this Choreo. 

		@param String - (required, string) The AccountSID provided when you signed up for a Twilio account.
		*/
		public void set_AccountSID(String value) {
			this.setInput("AccountSID", value);
		}


		/** 
		Set the value of the AreaCode input for this Choreo. 

		@param Integer - (optional, integer) Find phone numbers in the specified area code. (US and Canada only).
		*/
		public void set_AreaCode(Integer value) {
			this.setInput("AreaCode", value);
		}

		/** 
		Set the value of the AreaCode input for this Choreo as a String. 

		@param String - (optional, integer) Find phone numbers in the specified area code. (US and Canada only).
		*/
		public void set_AreaCode(String value) {
			this.setInput("AreaCode", value);	
		}
		/** 
		Set the value of the AuthToken input for this Choreo. 

		@param String - (required, string) The authorization token provided when you signed up for a Twilio account.
		*/
		public void set_AuthToken(String value) {
			this.setInput("AuthToken", value);
		}


		/** 
		Set the value of the Contains input for this Choreo. 

		@param String - (optional, string) A pattern to match phone numbers on. Valid characters are '*' and [0-9a-zA-Z]. The '*' character will match any single digit.
		*/
		public void set_Contains(String value) {
			this.setInput("Contains", value);
		}


		/** 
		Set the value of the Distance input for this Choreo. 

		@param Integer - (optional, integer) Specifies the search radius for Latitude, Longitude, and NearNumber quires in miles. If not specified this defaults to 25 miles.
		*/
		public void set_Distance(Integer value) {
			this.setInput("Distance", value);
		}

		/** 
		Set the value of the Distance input for this Choreo as a String. 

		@param String - (optional, integer) Specifies the search radius for Latitude, Longitude, and NearNumber quires in miles. If not specified this defaults to 25 miles.
		*/
		public void set_Distance(String value) {
			this.setInput("Distance", value);	
		}
		/** 
		Set the value of the InLata input for this Choreo. 

		@param String - (optional, string) Limit results to a specific Local access and transport area (LATA). Given a phone number, search within the same LATA as that number.
		*/
		public void set_InLata(String value) {
			this.setInput("InLata", value);
		}


		/** 
		Set the value of the InPostalCode input for this Choreo. 

		@param Integer - (optional, integer) Limit results to a particular postal code. Given a phone number, search within the same postal code as that number. (US and Canada only).
		*/
		public void set_InPostalCode(Integer value) {
			this.setInput("InPostalCode", value);
		}

		/** 
		Set the value of the InPostalCode input for this Choreo as a String. 

		@param String - (optional, integer) Limit results to a particular postal code. Given a phone number, search within the same postal code as that number. (US and Canada only).
		*/
		public void set_InPostalCode(String value) {
			this.setInput("InPostalCode", value);	
		}
		/** 
		Set the value of the InRateCenter input for this Choreo. 

		@param String - (optional, string) Limit results to a specific rate center, or given a phone number search within the same rate center as that number. Requires InLata to be set as well.
		*/
		public void set_InRateCenter(String value) {
			this.setInput("InRateCenter", value);
		}


		/** 
		Set the value of the InRegion input for this Choreo. 

		@param String - (optional, string) Limit results to a particular region (i.e. State/Province). Given a phone number, search within the same Region as that number. (US and Canada only).
		*/
		public void set_InRegion(String value) {
			this.setInput("InRegion", value);
		}


		/** 
		Set the value of the IsoCountryCode input for this Choreo. 

		@param String - (optional, string) The country code to search within. Defaults to US.
		*/
		public void set_IsoCountryCode(String value) {
			this.setInput("IsoCountryCode", value);
		}


		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (optional, decimal) Finds numbers close to this Latitude coordinate. Longitude is also required when searching by coordinates.
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (optional, decimal) Finds numbers close to this Latitude coordinate. Longitude is also required when searching by coordinates.
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param String - (optional, string) Finds numbers close this Longitude. Latitude is also required when searching by coordinates.
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);
		}


		/** 
		Set the value of the NearNumber input for this Choreo. 

		@param String - (optional, string) Searches numbers near  this phone number.
		*/
		public void set_NearNumber(String value) {
			this.setInput("NearNumber", value);
		}


		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) The page of results to retrieve. Defaults to 0.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) The page of results to retrieve. Defaults to 0.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the PageSize input for this Choreo. 

		@param Integer - (optional, integer) The number of results per page.
		*/
		public void set_PageSize(Integer value) {
			this.setInput("PageSize", value);
		}

		/** 
		Set the value of the PageSize input for this Choreo as a String. 

		@param String - (optional, integer) The number of results per page.
		*/
		public void set_PageSize(String value) {
			this.setInput("PageSize", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the LocalList Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class LocalListResultSet extends ResultSet {
		public LocalListResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Twilio.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
