package com.temboo.Library.SendGrid.NewsletterAPI.Identity;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListAllIdentities

Retrieve information about a specified Identity.
*/
public class ListAllIdentities extends Choreography {

	/**
	Create a new instance of the ListAllIdentities Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListAllIdentities(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/SendGrid/NewsletterAPI/Identity/ListAllIdentities"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListAllIdentitiesInputSet
	*/
	public ListAllIdentitiesInputSet newInputSet() {
		return new ListAllIdentitiesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListAllIdentitiesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListAllIdentitiesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListAllIdentities
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListAllIdentitiesInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key obtained from SendGrid.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the APIUser input for this Choreo. 

		@param String - (required, string) The username registered with SendGrid. 
		*/
		public void set_APIUser(String value) {
			this.setInput("APIUser", value);
		}


		/** 
		Set the value of the Identity input for this Choreo. 

		@param String - (optional, string) The identity for which info will be retrieved. Leave it empty to list all Identities in this account.
		*/
		public void set_Identity(String value) {
			this.setInput("Identity", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format of the response from SendGrid. Specify json, or xml.  Default is set to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the VaultFile input for this Choreo. 

		@param TembooPath - 
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListAllIdentities Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListAllIdentitiesResultSet extends ResultSet {
		public ListAllIdentitiesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from SendGrid. The format corresponds to the ResponseFormat input. Default is json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
