package com.temboo.Library.RunKeeper.BackgroundActivities;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
RetrieveLatestActivity

Returns the latest activity from a user's background activities history.
*/
public class RetrieveLatestActivity extends Choreography {

	/**
	Create a new instance of the RetrieveLatestActivity Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public RetrieveLatestActivity(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/RunKeeper/BackgroundActivities/RetrieveLatestActivity"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return RetrieveLatestActivityInputSet
	*/
	public RetrieveLatestActivityInputSet newInputSet() {
		return new RetrieveLatestActivityInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public RetrieveLatestActivityResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new RetrieveLatestActivityResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the RetrieveLatestActivity
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class RetrieveLatestActivityInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved after the final step in the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the RetrieveLatestActivity Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class RetrieveLatestActivityResultSet extends ResultSet {
		public RetrieveLatestActivityResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Steps" output from this Choreo execution

		@return String - (integer) The number of steps taken in this activity.
		*/
		public String get_Steps() {
			return this.getResultString("Steps");
		}
		/** 
		Retrieve the value for the "Timestamp" output from this Choreo execution

		@return String - (date) The timestamp of the activity.
		*/
		public String get_Timestamp() {
			return this.getResultString("Timestamp");
		}
		/** 
		Retrieve the value for the "URI" output from this Choreo execution

		@return String - (string) The URI of the activity.
		*/
		public String get_URI() {
			return this.getResultString("URI");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from RunKeeper.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
