package com.temboo.Library.Pusher.Users;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListUsers

Retrieves IDs for users currently subscribed to a presence channel.
*/
public class ListUsers extends Choreography {

	/**
	Create a new instance of the ListUsers Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListUsers(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Pusher/Users/ListUsers"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListUsersInputSet
	*/
	public ListUsersInputSet newInputSet() {
		return new ListUsersInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListUsersResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListUsersResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListUsers
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListUsersInputSet extends InputSet {
		/** 
		Set the value of the AppID input for this Choreo. 

		@param String - (required, string) The application ID provided by Pusher.
		*/
		public void set_AppID(String value) {
			this.setInput("AppID", value);
		}


		/** 
		Set the value of the AppKey input for this Choreo. 

		@param String - (required, string) The authenticaion key provided by Pusher.
		*/
		public void set_AppKey(String value) {
			this.setInput("AppKey", value);
		}


		/** 
		Set the value of the AppSecret input for this Choreo. 

		@param String - (required, string) The authentication secret provided by Pusher.
		*/
		public void set_AppSecret(String value) {
			this.setInput("AppSecret", value);
		}


		/** 
		Set the value of the ChannelName input for this Choreo. 

		@param String - (required, string) The name of the channel that the users are subscribed to.
		*/
		public void set_ChannelName(String value) {
			this.setInput("ChannelName", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListUsers Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListUsersResultSet extends ResultSet {
		public ListUsersResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Pusher.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
