package com.temboo.Library.PayPal.Merchant;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
MakeIndividualPayment

Retrieves the available balance for a PayPal account.
*/
public class MakeIndividualPayment extends Choreography {

	/**
	Create a new instance of the MakeIndividualPayment Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public MakeIndividualPayment(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/PayPal/Merchant/MakeIndividualPayment"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return MakeIndividualPaymentInputSet
	*/
	public MakeIndividualPaymentInputSet newInputSet() {
		return new MakeIndividualPaymentInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public MakeIndividualPaymentResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new MakeIndividualPaymentResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the MakeIndividualPayment
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class MakeIndividualPaymentInputSet extends InputSet {
		/** 
		Set the value of the CurrencyCode input for this Choreo. 

		@param String - (optional, string) The currency code associated with the PaymentAmount. Defaults to "USD".
		*/
		public void set_CurrencyCode(String value) {
			this.setInput("CurrencyCode", value);
		}


		/** 
		Set the value of the EmailAddress input for this Choreo. 

		@param String - (required, string) The email address used to identify the recipient of the payment.
		*/
		public void set_EmailAddress(String value) {
			this.setInput("EmailAddress", value);
		}


		/** 
		Set the value of the EmailSubject input for this Choreo. 

		@param String - (optional, string) The subject line of the email that PayPal sends when the transaction is completed. Character length and limitations: 255 single-byte alphanumeric characters.
		*/
		public void set_EmailSubject(String value) {
			this.setInput("EmailSubject", value);
		}


		/** 
		Set the value of the Password input for this Choreo. 

		@param String - (required, password) The API Password provided by PayPal.
		*/
		public void set_Password(String value) {
			this.setInput("Password", value);
		}


		/** 
		Set the value of the PaymentAmount input for this Choreo. 

		@param BigDecimal - (required, decimal) The amount to be paid.
		*/
		public void set_PaymentAmount(BigDecimal value) {
			this.setInput("PaymentAmount", value);
		}

		/** 
		Set the value of the PaymentAmount input for this Choreo as a String. 

		@param String - (required, decimal) The amount to be paid.
		*/
		public void set_PaymentAmount(String value) {
			this.setInput("PaymentAmount", value);	
		}
		/** 
		Set the value of the Signature input for this Choreo. 

		@param String - (required, string) The API Signature provided by PayPal.
		*/
		public void set_Signature(String value) {
			this.setInput("Signature", value);
		}


		/** 
		Set the value of the UseSandbox input for this Choreo. 

		@param Boolean - (conditional, boolean) Set to 1 to indicate that you're testing against the PayPal sandbox instead of production. Set to 0 (the default) when moving to production.
		*/
		public void set_UseSandbox(Boolean value) {
			this.setInput("UseSandbox", value);
		}

		/** 
		Set the value of the UseSandbox input for this Choreo as a String. 

		@param String - (conditional, boolean) Set to 1 to indicate that you're testing against the PayPal sandbox instead of production. Set to 0 (the default) when moving to production.
		*/
		public void set_UseSandbox(String value) {
			this.setInput("UseSandbox", value);	
		}
		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) The API Username provided by PayPal.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the MakeIndividualPayment Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class MakeIndividualPaymentResultSet extends ResultSet {
		public MakeIndividualPaymentResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Acknowledged" output from this Choreo execution

		@return String - (string) Indicates the status of the request. Should contain "Sucess" or "Failure".
		*/
		public String get_Acknowledged() {
			return this.getResultString("Acknowledged");
		}
		/** 
		Retrieve the value for the "CorrelationId" output from this Choreo execution

		@return String - (string) A unique id returned by PayPal for this payment.
		*/
		public String get_CorrelationId() {
			return this.getResultString("CorrelationId");
		}
		/** 
		Retrieve the value for the "ErrorMessage" output from this Choreo execution

		@return String - (string) This will contain any error message returned by PayPal during this operation.
		*/
		public String get_ErrorMessage() {
			return this.getResultString("ErrorMessage");
		}
		/** 
		Retrieve the value for the "Timestamp" output from this Choreo execution

		@return String - (date) The timestamp associated with the payment request.
		*/
		public String get_Timestamp() {
			return this.getResultString("Timestamp");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (string) The full response from PayPal formatted in name/value pairs.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
