package com.temboo.Library.Nexmo.Search;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SearchRejectedMessages

Search for a previously sent message by Message ID.  Note that a sent message won't be immediately available for search.
*/
public class SearchRejectedMessages extends Choreography {

	/**
	Create a new instance of the SearchRejectedMessages Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SearchRejectedMessages(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Nexmo/Search/SearchRejectedMessages"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SearchRejectedMessagesInputSet
	*/
	public SearchRejectedMessagesInputSet newInputSet() {
		return new SearchRejectedMessagesInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SearchRejectedMessagesResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SearchRejectedMessagesResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SearchRejectedMessages
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SearchRejectedMessagesInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) Your API Key provided to you by Nexmo.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the APISecret input for this Choreo. 

		@param String - (required, string) Your API Secret provided to you by Nexmo.
		*/
		public void set_APISecret(String value) {
			this.setInput("APISecret", value);
		}


		/** 
		Set the value of the Date input for this Choreo. 

		@param String - (required, string) Date message was sent in the form of YYYY-MM-DD. (e.g. 2013-07-01)
		*/
		public void set_Date(String value) {
			this.setInput("Date", value);
		}


		/** 
		Set the value of the MessageID input for this Choreo. 

		@param String - (required, string) Your Message ID.
		*/
		public void set_MessageID(String value) {
			this.setInput("MessageID", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are "json" (the default) and "xml".
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the To input for this Choreo. 

		@param String - (required, string) The recipient's phone number.  (e.g. 123456780)
		*/
		public void set_To(String value) {
			this.setInput("To", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SearchRejectedMessages Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SearchRejectedMessagesResultSet extends ResultSet {
		public SearchRejectedMessagesResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Nexmo. Corresponds to the ResponseFormat input. Defaults to json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
