package com.temboo.Library.NYTimes.CampaignFinance.Candidates;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CandidateDetails

Obtain finance details for a Presidential or Congressional candidate.
*/
public class CandidateDetails extends Choreography {

	/**
	Create a new instance of the CandidateDetails Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CandidateDetails(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/NYTimes/CampaignFinance/Candidates/CandidateDetails"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CandidateDetailsInputSet
	*/
	public CandidateDetailsInputSet newInputSet() {
		return new CandidateDetailsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CandidateDetailsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CandidateDetailsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CandidateDetails
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CandidateDetailsInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided by NY Times.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the CampaignCycle input for this Choreo. 

		@param Integer - (required, integer) Enter the campaign cycle year in YYYY format.  This must be an even year.
		*/
		public void set_CampaignCycle(Integer value) {
			this.setInput("CampaignCycle", value);
		}

		/** 
		Set the value of the CampaignCycle input for this Choreo as a String. 

		@param String - (required, integer) Enter the campaign cycle year in YYYY format.  This must be an even year.
		*/
		public void set_CampaignCycle(String value) {
			this.setInput("CampaignCycle", value);	
		}
		/** 
		Set the value of the FECID input for this Choreo. 

		@param String - (required, string) Enter the FEC ID for the candidate.  ID can be obtained by first running the CandidateSearch Choreo.
		*/
		public void set_FECID(String value) {
			this.setInput("FECID", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) Enter json or xml.  Default is json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CandidateDetails Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CandidateDetailsResultSet extends ResultSet {
		public CandidateDetailsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from the NY Times API corresponds to the setting (json, or xml) entered in the ResponseFormat variable.  Default is set to json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
