package com.temboo.Library.Mixpanel.DataExport.Segmentation;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Sum

Sums an expression for events per unit time.
*/
public class Sum extends Choreography {

	/**
	Create a new instance of the Sum Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Sum(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Mixpanel/DataExport/Segmentation/Sum"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SumInputSet
	*/
	public SumInputSet newInputSet() {
		return new SumInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SumResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SumResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Sum
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SumInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key provided my Mixpanel. You can find your Mixpanel API Key in the project settings dialog in the Mixpanel app.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the APISecret input for this Choreo. 

		@param String - (required, string) The API Secret provided by Mixpanel. You can find your Mixpanel API Secret in the project settings dialog in the Mixpanel app.
		*/
		public void set_APISecret(String value) {
			this.setInput("APISecret", value);
		}


		/** 
		Set the value of the EventName input for this Choreo. 

		@param String - (required, string) The event that you wish to segment on.
		*/
		public void set_EventName(String value) {
			this.setInput("EventName", value);
		}


		/** 
		Set the value of the Expire input for this Choreo. 

		@param Integer - (optional, integer) The amount of minutes past NOW() before the request will expire. Defaults to 1.
		*/
		public void set_Expire(Integer value) {
			this.setInput("Expire", value);
		}

		/** 
		Set the value of the Expire input for this Choreo as a String. 

		@param String - (optional, integer) The amount of minutes past NOW() before the request will expire. Defaults to 1.
		*/
		public void set_Expire(String value) {
			this.setInput("Expire", value);	
		}
		/** 
		Set the value of the FromDate input for this Choreo. 

		@param String - (required, date) The date in yyyy-mm-dd format from which to begin querying for the event from. This date is inclusive.
		*/
		public void set_FromDate(String value) {
			this.setInput("FromDate", value);
		}


		/** 
		Set the value of the On input for this Choreo. 

		@param String - (required, string) The expression to sum per unit time. Must be a numeric expression (e.g., number(properties["time"]). See Choreo description for examples.
		*/
		public void set_On(String value) {
			this.setInput("On", value);
		}


		/** 
		Set the value of the ToDate input for this Choreo. 

		@param String - (required, date) The date in yyyy-mm-dd format from which to stop querying for the event from. This date is inclusive. The date range may not be more than 30 days.
		*/
		public void set_ToDate(String value) {
			this.setInput("ToDate", value);
		}


		/** 
		Set the value of the Unit input for this Choreo. 

		@param String - (optional, string) Determines the buckets into which the property values that you segment on are placed. Valid values are: hour or day.
		*/
		public void set_Unit(String value) {
			this.setInput("Unit", value);
		}


		/** 
		Set the value of the Where input for this Choreo. 

		@param String - (optional, string) An expression to filter events by  (e.g., number(properties["time"]) >= 2000). See Choreo description for examples.
		*/
		public void set_Where(String value) {
			this.setInput("Where", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Sum Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SumResultSet extends ResultSet {
		public SumResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Mixpanel.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
