package com.temboo.Library.LittleSis.Entity;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetSecondDegreeRelationships

Retrieves a list of all the Entities (people or organizations) that are two-degrees removed by Relationships from the given Entity.
*/
public class GetSecondDegreeRelationships extends Choreography {

	/**
	Create a new instance of the GetSecondDegreeRelationships Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetSecondDegreeRelationships(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/LittleSis/Entity/GetSecondDegreeRelationships"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetSecondDegreeRelationshipsInputSet
	*/
	public GetSecondDegreeRelationshipsInputSet newInputSet() {
		return new GetSecondDegreeRelationshipsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetSecondDegreeRelationshipsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetSecondDegreeRelationshipsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetSecondDegreeRelationships
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetSecondDegreeRelationshipsInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key obtained from LittleSis.org.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Category1 input for this Choreo. 

		@param String - (optional, string) Comma delimited list of Category IDs. Restricts the categories of Relationships that the given Entity and all first degree Entities returned should be connected through.
		*/
		public void set_Category1(String value) {
			this.setInput("Category1", value);
		}


		/** 
		Set the value of the Category2 input for this Choreo. 

		@param String - (optional, string) Comma delimited list of Category IDs. Restricts the categories of Relationships that the given Entity and all second degree Entities returned should be connected through.
		*/
		public void set_Category2(String value) {
			this.setInput("Category2", value);
		}


		/** 
		Set the value of the EntityID input for this Choreo. 

		@param Integer - (required, integer) The ID of the person or organization for which records are to be returned.
		*/
		public void set_EntityID(Integer value) {
			this.setInput("EntityID", value);
		}

		/** 
		Set the value of the EntityID input for this Choreo as a String. 

		@param String - (required, integer) The ID of the person or organization for which records are to be returned.
		*/
		public void set_EntityID(String value) {
			this.setInput("EntityID", value);	
		}
		/** 
		Set the value of the Number input for this Choreo. 

		@param Integer - (optional, integer) Specifies what number of results to show. Used in conjunction with Page parameter, a Number of 20 and a Page of 6 will show results 100-120. Defaults to 20.
		*/
		public void set_Number(Integer value) {
			this.setInput("Number", value);
		}

		/** 
		Set the value of the Number input for this Choreo as a String. 

		@param String - (optional, integer) Specifies what number of results to show. Used in conjunction with Page parameter, a Number of 20 and a Page of 6 will show results 100-120. Defaults to 20.
		*/
		public void set_Number(String value) {
			this.setInput("Number", value);	
		}
		/** 
		Set the value of the Order1 input for this Choreo. 

		@param Integer - (optional, integer) Specifies the order of the Entities returned in the first degree Relationship. Acceptable values: 1 or 2. See documentation for more on Relationship order.
		*/
		public void set_Order1(Integer value) {
			this.setInput("Order1", value);
		}

		/** 
		Set the value of the Order1 input for this Choreo as a String. 

		@param String - (optional, integer) Specifies the order of the Entities returned in the first degree Relationship. Acceptable values: 1 or 2. See documentation for more on Relationship order.
		*/
		public void set_Order1(String value) {
			this.setInput("Order1", value);	
		}
		/** 
		Set the value of the Order2 input for this Choreo. 

		@param Integer - (optional, integer) Specifies the order of the first degree Entity in the second degree Relationship. Acceptable values: 1 or 2. See documentation for more on Relationship order.
		*/
		public void set_Order2(Integer value) {
			this.setInput("Order2", value);
		}

		/** 
		Set the value of the Order2 input for this Choreo as a String. 

		@param String - (optional, integer) Specifies the order of the first degree Entity in the second degree Relationship. Acceptable values: 1 or 2. See documentation for more on Relationship order.
		*/
		public void set_Order2(String value) {
			this.setInput("Order2", value);	
		}
		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) Specifies what page of results to show. Used in conjunction with Number parameter. A number of 20 and a Page of 6 will show results 100-120.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) Specifies what page of results to show. Used in conjunction with Number parameter. A number of 20 and a Page of 6 will show results 100-120.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) Format of the response returned by LittleSis.org. Acceptable inputs: xml or json. Defaults to xml
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetSecondDegreeRelationships Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetSecondDegreeRelationshipsResultSet extends ResultSet {
		public GetSecondDegreeRelationshipsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from LittleSis.org.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
