package com.temboo.Library.LittleSis.Entity;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetChainsByEntity

Retrieves a chain of connections between two Entities (person or organization) in LittleSis.
*/
public class GetChainsByEntity extends Choreography {

	/**
	Create a new instance of the GetChainsByEntity Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetChainsByEntity(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/LittleSis/Entity/GetChainsByEntity"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetChainsByEntityInputSet
	*/
	public GetChainsByEntityInputSet newInputSet() {
		return new GetChainsByEntityInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetChainsByEntityResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetChainsByEntityResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetChainsByEntity
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetChainsByEntityInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key obtained from LittleSis.org.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the CategoryID input for this Choreo. 

		@param Integer - (optional, integer) Limit the relationships to specific categories by specifying the category number.
		*/
		public void set_CategoryID(Integer value) {
			this.setInput("CategoryID", value);
		}

		/** 
		Set the value of the CategoryID input for this Choreo as a String. 

		@param String - (optional, integer) Limit the relationships to specific categories by specifying the category number.
		*/
		public void set_CategoryID(String value) {
			this.setInput("CategoryID", value);	
		}
		/** 
		Set the value of the EntityIDs input for this Choreo. 

		@param Integer - (required, integer) The EntityIDs of the two entities for which a relationship chain is to be returned, separated by a semicolon (e.g. 14629;2 ).
		*/
		public void set_EntityIDs(Integer value) {
			this.setInput("EntityIDs", value);
		}

		/** 
		Set the value of the EntityIDs input for this Choreo as a String. 

		@param String - (required, integer) The EntityIDs of the two entities for which a relationship chain is to be returned, separated by a semicolon (e.g. 14629;2 ).
		*/
		public void set_EntityIDs(String value) {
			this.setInput("EntityIDs", value);	
		}
		/** 
		Set the value of the Page input for this Choreo. 

		@param String - (optional, string) Specifies which of the found chain to expand in detail. Default is 1.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) Format of the response returned by LittleSis.org. Acceptable inputs: xml or json. Defaults to xml
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetChainsByEntity Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetChainsByEntityResultSet extends ResultSet {
		public GetChainsByEntityResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from LittleSis.org.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
