package com.temboo.Library.LittleSis.Entity;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
EntitySearchByKeyword

Retrieves Entities (people or organizations) in LittleSis that match a given keyword search.
*/
public class EntitySearchByKeyword extends Choreography {

	/**
	Create a new instance of the EntitySearchByKeyword Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public EntitySearchByKeyword(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/LittleSis/Entity/EntitySearchByKeyword"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return EntitySearchByKeywordInputSet
	*/
	public EntitySearchByKeywordInputSet newInputSet() {
		return new EntitySearchByKeywordInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public EntitySearchByKeywordResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new EntitySearchByKeywordResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the EntitySearchByKeyword
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class EntitySearchByKeywordInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) The API Key obtained from LittleSis.org.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Keywords input for this Choreo. 

		@param String - (required, string) Enter search text.
		*/
		public void set_Keywords(String value) {
			this.setInput("Keywords", value);
		}


		/** 
		Set the value of the Number input for this Choreo. 

		@param Integer - (optional, integer) Specifies what number of results to show. Used in conjunction with Page parameter, a Number of 20 and a Page of 6 will show results 100-120.
		*/
		public void set_Number(Integer value) {
			this.setInput("Number", value);
		}

		/** 
		Set the value of the Number input for this Choreo as a String. 

		@param String - (optional, integer) Specifies what number of results to show. Used in conjunction with Page parameter, a Number of 20 and a Page of 6 will show results 100-120.
		*/
		public void set_Number(String value) {
			this.setInput("Number", value);	
		}
		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) Specifies what page of results to show. Used in conjunction with Number parameter. A number of 20 and a Page of 6 will show results 100-120.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) Specifies what page of results to show. Used in conjunction with Number parameter. A number of 20 and a Page of 6 will show results 100-120.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) Format of the response returned by LittleSis.org. Acceptable inputs: xml or json. Defaults to xml
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the SearchAll input for this Choreo. 

		@param Integer - (optional, integer) Enter 1 to search a record's description and summary fields. When not specified, only the name and aliases fields of each record will be searched.
		*/
		public void set_SearchAll(Integer value) {
			this.setInput("SearchAll", value);
		}

		/** 
		Set the value of the SearchAll input for this Choreo as a String. 

		@param String - (optional, integer) Enter 1 to search a record's description and summary fields. When not specified, only the name and aliases fields of each record will be searched.
		*/
		public void set_SearchAll(String value) {
			this.setInput("SearchAll", value);	
		}
		/** 
		Set the value of the TypeIDs input for this Choreo. 

		@param String - (optional, string) You can specify a TypeIDs value to limit the search results to only those of a given type. Obtain all possible types and type ID's by first running the GetTypes Choreo.
		*/
		public void set_TypeIDs(String value) {
			this.setInput("TypeIDs", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the EntitySearchByKeyword Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class EntitySearchByKeywordResultSet extends ResultSet {
		public EntitySearchByKeywordResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from LittleSis.org.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
