package com.temboo.Library.LastFm.Album;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetTags

Retrieves the tags applied by an individual user to an album on Last.fm.
*/
public class GetTags extends Choreography {

	/**
	Create a new instance of the GetTags Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetTags(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/LastFm/Album/GetTags"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetTagsInputSet
	*/
	public GetTagsInputSet newInputSet() {
		return new GetTagsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetTagsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetTagsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetTags
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetTagsInputSet extends InputSet {
		/** 
		Set the value of the APIKey input for this Choreo. 

		@param String - (required, string) Your Last.fm API Key.
		*/
		public void set_APIKey(String value) {
			this.setInput("APIKey", value);
		}


		/** 
		Set the value of the Album input for this Choreo. 

		@param String - (conditional, string) The album name. Required unless providing MbID.
		*/
		public void set_Album(String value) {
			this.setInput("Album", value);
		}


		/** 
		Set the value of the Artist input for this Choreo. 

		@param String - (conditional, string) The artist name. Required unless providing MbID.
		*/
		public void set_Artist(String value) {
			this.setInput("Artist", value);
		}


		/** 
		Set the value of the AutoCorrect input for this Choreo. 

		@param Boolean - (optional, boolean) Transform misspelled artist names into correct artist names. The corrected artist name will be returned in the response. Defaults to 0.
		*/
		public void set_AutoCorrect(Boolean value) {
			this.setInput("AutoCorrect", value);
		}

		/** 
		Set the value of the AutoCorrect input for this Choreo as a String. 

		@param String - (optional, boolean) Transform misspelled artist names into correct artist names. The corrected artist name will be returned in the response. Defaults to 0.
		*/
		public void set_AutoCorrect(String value) {
			this.setInput("AutoCorrect", value);	
		}
		/** 
		Set the value of the MbID input for this Choreo. 

		@param String - (conditional, string) The musicbrainz id for the album. Required unless providing the Album and Artist.
		*/
		public void set_MbID(String value) {
			this.setInput("MbID", value);
		}


		/** 
		Set the value of the User input for this Choreo. 

		@param String - (required, string) The last.fm username to lookup.
		*/
		public void set_User(String value) {
			this.setInput("User", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetTags Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetTagsResultSet extends ResultSet {
		public GetTagsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Last.fm.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
