package com.temboo.Library.KhanAcademy.Videos;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetVideoByReadableID

Retrieves video data for a given video according to its readable ID.
*/
public class GetVideoByReadableID extends Choreography {

	/**
	Create a new instance of the GetVideoByReadableID Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetVideoByReadableID(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/KhanAcademy/Videos/GetVideoByReadableID"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetVideoByReadableIDInputSet
	*/
	public GetVideoByReadableIDInputSet newInputSet() {
		return new GetVideoByReadableIDInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetVideoByReadableIDResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetVideoByReadableIDResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetVideoByReadableID
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetVideoByReadableIDInputSet extends InputSet {
		/** 
		Set the value of the ReadableID input for this Choreo. 

		@param String - (required, string) The ReadableID of the video for which you want to retrieve information (e.g. adding-subtracting-negative-numbers).
		*/
		public void set_ReadableID(String value) {
			this.setInput("ReadableID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetVideoByReadableID Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetVideoByReadableIDResultSet extends ResultSet {
		public GetVideoByReadableIDResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Khan Academy.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
