package com.temboo.Library.KhanAcademy.Topics;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetTopicVideos

Retreievs a list of all videos for a given topic.
*/
public class GetTopicVideos extends Choreography {

	/**
	Create a new instance of the GetTopicVideos Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetTopicVideos(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/KhanAcademy/Topics/GetTopicVideos"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetTopicVideosInputSet
	*/
	public GetTopicVideosInputSet newInputSet() {
		return new GetTopicVideosInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetTopicVideosResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetTopicVideosResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetTopicVideos
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetTopicVideosInputSet extends InputSet {
		/** 
		Set the value of the TopicID input for this Choreo. 

		@param String - (required, string) The ID of the topic.
		*/
		public void set_TopicID(String value) {
			this.setInput("TopicID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetTopicVideos Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetTopicVideosResultSet extends ResultSet {
		public GetTopicVideosResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Khan Academy.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
