package com.temboo.Library.GovTrack;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
VoteAndVoter

Retrieves how people voted on roll call votes in the U.S. Congress since 1789. 
*/
public class VoteAndVoter extends Choreography {

	/**
	Create a new instance of the VoteAndVoter Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public VoteAndVoter(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/GovTrack/VoteAndVoter"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return VoteAndVoterInputSet
	*/
	public VoteAndVoterInputSet newInputSet() {
		return new VoteAndVoterInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public VoteAndVoterResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new VoteAndVoterResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the VoteAndVoter
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class VoteAndVoterInputSet extends InputSet {
		/** 
		Set the value of the Created input for this Choreo. 

		@param String - (optional, string) The date (and in recent history also the time) on which the vote was held (in YYYY-MM-DD format). Filter operators allowed. Sortable.
		*/
		public void set_Created(String value) {
			this.setInput("Created", value);
		}


		/** 
		Set the value of the Fields input for this Choreo. 

		@param String - (optional, string) A comma separated list of fields to return in the response. Use double-underscores to span relationships (e.g. person__firstname).
		*/
		public void set_Fields(String value) {
			this.setInput("Fields", value);
		}


		/** 
		Set the value of the Limit input for this Choreo. 

		@param Integer - (optional, integer) Results are paged 100 per call by default. Set the limit input to a high value to get all of the results at once.
		*/
		public void set_Limit(Integer value) {
			this.setInput("Limit", value);
		}

		/** 
		Set the value of the Limit input for this Choreo as a String. 

		@param String - (optional, integer) Results are paged 100 per call by default. Set the limit input to a high value to get all of the results at once.
		*/
		public void set_Limit(String value) {
			this.setInput("Limit", value);	
		}
		/** 
		Set the value of the ObjectID input for this Choreo. 

		@param Integer - (optional, integer) The ID of the resource to retrieve. When using this input, all other filter parameters are ignored, and a single record is returned.
		*/
		public void set_ObjectID(Integer value) {
			this.setInput("ObjectID", value);
		}

		/** 
		Set the value of the ObjectID input for this Choreo as a String. 

		@param String - (optional, integer) The ID of the resource to retrieve. When using this input, all other filter parameters are ignored, and a single record is returned.
		*/
		public void set_ObjectID(String value) {
			this.setInput("ObjectID", value);	
		}
		/** 
		Set the value of the Offset input for this Choreo. 

		@param Integer - (optional, integer) Offset the results by the number given, useful for paging through results.
		*/
		public void set_Offset(Integer value) {
			this.setInput("Offset", value);
		}

		/** 
		Set the value of the Offset input for this Choreo as a String. 

		@param String - (optional, integer) Offset the results by the number given, useful for paging through results.
		*/
		public void set_Offset(String value) {
			this.setInput("Offset", value);	
		}
		/** 
		Set the value of the Option input for this Choreo. 

		@param String - (optional, string) The way a particular person voted. The value corresponds to the key of an option returned on the Vote Choreo. Filter operators allowed. Sortable.
		*/
		public void set_Option(String value) {
			this.setInput("Option", value);
		}


		/** 
		Set the value of the Person input for this Choreo. 

		@param String - (optional, string) The person making this vote. This is an ID number. Filter operators allowed. Sortable.
		*/
		public void set_Person(String value) {
			this.setInput("Person", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and xml.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Sort input for this Choreo. 

		@param String - (optional, string) You can order the results by date using fieldname (ascending) or -fieldname (descending), where "fieldname" is either startdate or enddate.
		*/
		public void set_Sort(String value) {
			this.setInput("Sort", value);
		}


		/** 
		Set the value of the Vote input for this Choreo. 

		@param String - (optional, string) The ID number of the vote that this was part of. This is in the form of an ID number. Filter operators allowed. Sortable.
		*/
		public void set_Vote(String value) {
			this.setInput("Vote", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the VoteAndVoter Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class VoteAndVoterResultSet extends ResultSet {
		public VoteAndVoterResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from GovTrack.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
