package com.temboo.Library.Google.Picasa;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListPhotosByAlbum

Lists all photos in a specified Google Picasa album.
*/
public class ListPhotosByAlbum extends Choreography {

	/**
	Create a new instance of the ListPhotosByAlbum Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListPhotosByAlbum(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Picasa/ListPhotosByAlbum"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListPhotosByAlbumInputSet
	*/
	public ListPhotosByAlbumInputSet newInputSet() {
		return new ListPhotosByAlbumInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListPhotosByAlbumResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListPhotosByAlbumResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListPhotosByAlbum
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListPhotosByAlbumInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AlbumID input for this Choreo. 

		@param Integer - (required, integer) The album id. Note that this can be retrieved by running the ListAlbums Choreo.
		*/
		public void set_AlbumID(Integer value) {
			this.setInput("AlbumID", value);
		}

		/** 
		Set the value of the AlbumID input for this Choreo as a String. 

		@param String - (required, integer) The album id. Note that this can be retrieved by running the ListAlbums Choreo.
		*/
		public void set_AlbumID(String value) {
			this.setInput("AlbumID", value);	
		}
		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (conditional, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


		/** 
		Set the value of the UserID input for this Choreo. 

		@param String - (optional, string) Google Picasa username. Defaults to 'default' which means the server will use the UserID of the user whose access token was specified.
		*/
		public void set_UserID(String value) {
			this.setInput("UserID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListPhotosByAlbum Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListPhotosByAlbumResultSet extends ResultSet {
		public ListPhotosByAlbumResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the RefreshToken is provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (xml) The response from Google Picasa.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
