package com.temboo.Library.Google.Contacts;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
DeleteContact

Deletes a specified contact.
*/
public class DeleteContact extends Choreography {

	/**
	Create a new instance of the DeleteContact Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public DeleteContact(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Contacts/DeleteContact"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return DeleteContactInputSet
	*/
	public DeleteContactInputSet newInputSet() {
		return new DeleteContactInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public DeleteContactResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new DeleteContactResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the DeleteContact
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class DeleteContactInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) The access token retrieved in the last step of the OAuth process. Access tokens that are expired will be refreshed and returned in the Choreo output.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (required, string) The OAuth client ID provided by Google when you register your application.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (required, string) The OAuth client secret provided by Google when you registered your application.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the ContactID input for this Choreo. 

		@param String - (required, string) The unique ID string for the contact you want to delete.
		*/
		public void set_ContactID(String value) {
			this.setInput("ContactID", value);
		}


		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (required, string) The refresh token retrieved in the last step of the OAuth process. This is used when an access token is expired or not provided.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the DeleteContact Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class DeleteContactResultSet extends ResultSet {
		public DeleteContactResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "AccessToken" output from this Choreo execution

		@return String - (optional, string) The access token retrieved in the last step of the OAuth process. Access tokens that are expired will be refreshed and returned in the Choreo output.
		*/
		public String get_AccessToken() {
			return this.getResultString("AccessToken");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Google. No content is returned for a successful delete request.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
