package com.temboo.Library.Google.Calendar;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
SearchEvents

Allows you to search for events using a variety of search parameters.
*/
public class SearchEvents extends Choreography {

	/**
	Create a new instance of the SearchEvents Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public SearchEvents(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Google/Calendar/SearchEvents"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return SearchEventsInputSet
	*/
	public SearchEventsInputSet newInputSet() {
		return new SearchEventsInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public SearchEventsResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new SearchEventsResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the SearchEvents
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class SearchEventsInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (optional, string) A valid access token retrieved during the OAuth process. This is required unless you provide the ClientID, ClientSecret, and RefreshToken to generate a new access token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the CalendarID input for this Choreo. 

		@param String - (required, string) The unique ID for the calendar with the events to search. Note that calendar IDs can be retrieved by running GetAllCalendars or SearchCalendarsByName.
		*/
		public void set_CalendarID(String value) {
			this.setInput("CalendarID", value);
		}


		/** 
		Set the value of the ClientID input for this Choreo. 

		@param String - (conditional, string) The Client ID provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientID(String value) {
			this.setInput("ClientID", value);
		}


		/** 
		Set the value of the ClientSecret input for this Choreo. 

		@param String - (conditional, string) The Client Secret provided by Google. Required unless providing a valid AccessToken.
		*/
		public void set_ClientSecret(String value) {
			this.setInput("ClientSecret", value);
		}


		/** 
		Set the value of the LastModified input for this Choreo. 

		@param String - (optional, date) An event's last modification time (as a RFC 3339 timestamp) to filter by.
		*/
		public void set_LastModified(String value) {
			this.setInput("LastModified", value);
		}


		/** 
		Set the value of the MaxAttendees input for this Choreo. 

		@param Integer - (optional, integer) The maximum number of attendees to include in the response. If there are more than the specified number of attendees, only the participant is returned.
		*/
		public void set_MaxAttendees(Integer value) {
			this.setInput("MaxAttendees", value);
		}

		/** 
		Set the value of the MaxAttendees input for this Choreo as a String. 

		@param String - (optional, integer) The maximum number of attendees to include in the response. If there are more than the specified number of attendees, only the participant is returned.
		*/
		public void set_MaxAttendees(String value) {
			this.setInput("MaxAttendees", value);	
		}
		/** 
		Set the value of the MaxResults input for this Choreo. 

		@param Integer - (optional, integer) The maximum number of events to return on one result page.
		*/
		public void set_MaxResults(Integer value) {
			this.setInput("MaxResults", value);
		}

		/** 
		Set the value of the MaxResults input for this Choreo as a String. 

		@param String - (optional, integer) The maximum number of events to return on one result page.
		*/
		public void set_MaxResults(String value) {
			this.setInput("MaxResults", value);	
		}
		/** 
		Set the value of the MaxTime input for this Choreo. 

		@param String - (optional, date) The max start time to filter by (formatted like 2012-05-22T00:47:43.000Z).
		*/
		public void set_MaxTime(String value) {
			this.setInput("MaxTime", value);
		}


		/** 
		Set the value of the MinTime input for this Choreo. 

		@param String - (optional, date) The minimum start time to filter by (formatted like 2012-05-22T00:47:43.000Z).
		*/
		public void set_MinTime(String value) {
			this.setInput("MinTime", value);
		}


		/** 
		Set the value of the OrderBy input for this Choreo. 

		@param String - (optional, string) The order of the events returned in the result. Accepted values are: "startTime" (ordered by start date/time. Must set SingleEvents to 1 to use this) or "updated" (ordered by modification date/time).
		*/
		public void set_OrderBy(String value) {
			this.setInput("OrderBy", value);
		}


		/** 
		Set the value of the PageToken input for this Choreo. 

		@param Integer - (optional, integer) Indicates which result page to return. Used for paging through results.
		*/
		public void set_PageToken(Integer value) {
			this.setInput("PageToken", value);
		}

		/** 
		Set the value of the PageToken input for this Choreo as a String. 

		@param String - (optional, integer) Indicates which result page to return. Used for paging through results.
		*/
		public void set_PageToken(String value) {
			this.setInput("PageToken", value);	
		}
		/** 
		Set the value of the Query input for this Choreo. 

		@param String - (optional, string) A keyword search to find events.
		*/
		public void set_Query(String value) {
			this.setInput("Query", value);
		}


		/** 
		Set the value of the RefreshToken input for this Choreo. 

		@param String - (conditional, string) An OAuth Refresh Token used to generate a new access token when the original token is expired. Required unless providing a valid AccessToken.
		*/
		public void set_RefreshToken(String value) {
			this.setInput("RefreshToken", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the ShowDeleted input for this Choreo. 

		@param Boolean - (optional, boolean) Whether to include deleted events. Set to 1 (true) to include deleted events. Defaults to 0 (false).
		*/
		public void set_ShowDeleted(Boolean value) {
			this.setInput("ShowDeleted", value);
		}

		/** 
		Set the value of the ShowDeleted input for this Choreo as a String. 

		@param String - (optional, boolean) Whether to include deleted events. Set to 1 (true) to include deleted events. Defaults to 0 (false).
		*/
		public void set_ShowDeleted(String value) {
			this.setInput("ShowDeleted", value);	
		}
		/** 
		Set the value of the ShowHiddenInvitations input for this Choreo. 

		@param Boolean - (optional, boolean) Whether to include hidden invitations in the result. Set to 1 (true) to enable. The default is 0 (false).
		*/
		public void set_ShowHiddenInvitations(Boolean value) {
			this.setInput("ShowHiddenInvitations", value);
		}

		/** 
		Set the value of the ShowHiddenInvitations input for this Choreo as a String. 

		@param String - (optional, boolean) Whether to include hidden invitations in the result. Set to 1 (true) to enable. The default is 0 (false).
		*/
		public void set_ShowHiddenInvitations(String value) {
			this.setInput("ShowHiddenInvitations", value);	
		}
		/** 
		Set the value of the SingleEvent input for this Choreo. 

		@param Boolean - (optional, boolean) Whether to expand recurring events into instances and only return single one-off events and instances of recurring events. Defaults to 0 (false).
		*/
		public void set_SingleEvent(Boolean value) {
			this.setInput("SingleEvent", value);
		}

		/** 
		Set the value of the SingleEvent input for this Choreo as a String. 

		@param String - (optional, boolean) Whether to expand recurring events into instances and only return single one-off events and instances of recurring events. Defaults to 0 (false).
		*/
		public void set_SingleEvent(String value) {
			this.setInput("SingleEvent", value);	
		}
		/** 
		Set the value of the Timezone input for this Choreo. 

		@param String - (optional, string) The time zone used in the response (i.e. America/Los_Angeles). The default is the time zone of the calendar.
		*/
		public void set_Timezone(String value) {
			this.setInput("Timezone", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the SearchEvents Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class SearchEventsResultSet extends ResultSet {
		public SearchEventsResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "NewAccessToken" output from this Choreo execution

		@return String - (string) Contains a new AccessToken when the RefreshToken is provided.
		*/
		public String get_NewAccessToken() {
			return this.getResultString("NewAccessToken");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Google. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
