package com.temboo.Library.GitHub.ReposAPI.Repos;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateRepo

Creates a new repository for the authenticated user.
*/
public class CreateRepo extends Choreography {

	/**
	Create a new instance of the CreateRepo Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateRepo(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/GitHub/ReposAPI/Repos/CreateRepo"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateRepoInputSet
	*/
	public CreateRepoInputSet newInputSet() {
		return new CreateRepoInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateRepoResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateRepoResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateRepo
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateRepoInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Description input for this Choreo. 

		@param String - (optional, string) A text description for the repo.
		*/
		public void set_Description(String value) {
			this.setInput("Description", value);
		}


		/** 
		Set the value of the HasDownloads input for this Choreo. 

		@param Boolean - (optional, boolean) Se to "true" to enable downloads for this repository. Defaults to "true".
		*/
		public void set_HasDownloads(Boolean value) {
			this.setInput("HasDownloads", value);
		}

		/** 
		Set the value of the HasDownloads input for this Choreo as a String. 

		@param String - (optional, boolean) Se to "true" to enable downloads for this repository. Defaults to "true".
		*/
		public void set_HasDownloads(String value) {
			this.setInput("HasDownloads", value);	
		}
		/** 
		Set the value of the HasIssues input for this Choreo. 

		@param Boolean - (optional, boolean) Set to "true" to enable issues for this repository. Defaults to "true."
		*/
		public void set_HasIssues(Boolean value) {
			this.setInput("HasIssues", value);
		}

		/** 
		Set the value of the HasIssues input for this Choreo as a String. 

		@param String - (optional, boolean) Set to "true" to enable issues for this repository. Defaults to "true."
		*/
		public void set_HasIssues(String value) {
			this.setInput("HasIssues", value);	
		}
		/** 
		Set the value of the HasWiki input for this Choreo. 

		@param Boolean - (optional, boolean) Set to "true" to enable the wiki for this repository. Defaults to "true".
		*/
		public void set_HasWiki(Boolean value) {
			this.setInput("HasWiki", value);
		}

		/** 
		Set the value of the HasWiki input for this Choreo as a String. 

		@param String - (optional, boolean) Set to "true" to enable the wiki for this repository. Defaults to "true".
		*/
		public void set_HasWiki(String value) {
			this.setInput("HasWiki", value);	
		}
		/** 
		Set the value of the Homepage input for this Choreo. 

		@param String - (optional, string) A homepage link.
		*/
		public void set_Homepage(String value) {
			this.setInput("Homepage", value);
		}


		/** 
		Set the value of the Name input for this Choreo. 

		@param String - (required, string) The name of the repo being created.
		*/
		public void set_Name(String value) {
			this.setInput("Name", value);
		}


		/** 
		Set the value of the Private input for this Choreo. 

		@param Boolean - (optional, boolean) A flag indicating the the repo is private or public. Set to "true" to create a private repository. Defaults to "false".
		*/
		public void set_Private(Boolean value) {
			this.setInput("Private", value);
		}

		/** 
		Set the value of the Private input for this Choreo as a String. 

		@param String - (optional, boolean) A flag indicating the the repo is private or public. Set to "true" to create a private repository. Defaults to "false".
		*/
		public void set_Private(String value) {
			this.setInput("Private", value);	
		}
		/** 
		Set the value of the TeamID input for this Choreo. 

		@param Integer - (optional, integer) The id of the team that will be granted access to this repository. Only valid when creating a repo in an organization.
		*/
		public void set_TeamID(Integer value) {
			this.setInput("TeamID", value);
		}

		/** 
		Set the value of the TeamID input for this Choreo as a String. 

		@param String - (optional, integer) The id of the team that will be granted access to this repository. Only valid when creating a repo in an organization.
		*/
		public void set_TeamID(String value) {
			this.setInput("TeamID", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateRepo Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateRepoResultSet extends ResultSet {
		public CreateRepoResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Limit" output from this Choreo execution

		@return String - (integer) The available rate limit for your account. This is returned in the GitHub response header.
		*/
		public String get_Limit() {
			return this.getResultString("Limit");
		}
		/** 
		Retrieve the value for the "Remaining" output from this Choreo execution

		@return String - (integer) The remaining number of API requests available to you. This is returned in the GitHub response header.
		*/
		public String get_Remaining() {
			return this.getResultString("Remaining");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from GitHub.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
