package com.temboo.Library.GitHub.IssuesAPI.Issues;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
ListIssuesForRepo

List all issues for a specified repository.
*/
public class ListIssuesForRepo extends Choreography {

	/**
	Create a new instance of the ListIssuesForRepo Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public ListIssuesForRepo(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/GitHub/IssuesAPI/Issues/ListIssuesForRepo"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return ListIssuesForRepoInputSet
	*/
	public ListIssuesForRepoInputSet newInputSet() {
		return new ListIssuesForRepoInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public ListIssuesForRepoResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new ListIssuesForRepoResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the ListIssuesForRepo
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class ListIssuesForRepoInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The Access Token retrieved during the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Assignee input for this Choreo. 

		@param String - (required, string) Can be set to a username, "none" for issues with no assinged user, or * for issues with any assigned user.
		*/
		public void set_Assignee(String value) {
			this.setInput("Assignee", value);
		}


		/** 
		Set the value of the Creator input for this Choreo. 

		@param String - (optional, string) The user that created the issue.
		*/
		public void set_Creator(String value) {
			this.setInput("Creator", value);
		}


		/** 
		Set the value of the Direction input for this Choreo. 

		@param String - (optional, string) The direction of the sort order. Valid values are: asc or desc (the default).
		*/
		public void set_Direction(String value) {
			this.setInput("Direction", value);
		}


		/** 
		Set the value of the Labels input for this Choreo. 

		@param String - (optional, string) A comma separated list of label names (i.e. bug, ui, etc).
		*/
		public void set_Labels(String value) {
			this.setInput("Labels", value);
		}


		/** 
		Set the value of the Mentioned input for this Choreo. 

		@param String - (optional, string) A Github username that is mentioned.
		*/
		public void set_Mentioned(String value) {
			this.setInput("Mentioned", value);
		}


		/** 
		Set the value of the Milestone input for this Choreo. 

		@param String - (required, string) Can be set to a milestone number, "none" for issues with no milestone, or * for issues with any milestone.
		*/
		public void set_Milestone(String value) {
			this.setInput("Milestone", value);
		}


		/** 
		Set the value of the Page input for this Choreo. 

		@param Integer - (optional, integer) Indicates the page index that you want to retrieve. This is used to page through many results. Defaults to 1.
		*/
		public void set_Page(Integer value) {
			this.setInput("Page", value);
		}

		/** 
		Set the value of the Page input for this Choreo as a String. 

		@param String - (optional, integer) Indicates the page index that you want to retrieve. This is used to page through many results. Defaults to 1.
		*/
		public void set_Page(String value) {
			this.setInput("Page", value);	
		}
		/** 
		Set the value of the PerPage input for this Choreo. 

		@param Integer - (optional, integer) The number of results to return per page.
		*/
		public void set_PerPage(Integer value) {
			this.setInput("PerPage", value);
		}

		/** 
		Set the value of the PerPage input for this Choreo as a String. 

		@param String - (optional, integer) The number of results to return per page.
		*/
		public void set_PerPage(String value) {
			this.setInput("PerPage", value);	
		}
		/** 
		Set the value of the Repo input for this Choreo. 

		@param String - (required, string) The name of the repo.
		*/
		public void set_Repo(String value) {
			this.setInput("Repo", value);
		}


		/** 
		Set the value of the Since input for this Choreo. 

		@param String - (optional, date) A timestamp in ISO 8601 format (YYYY-MM-DDTHH:MM:SSZ). Returns issues since this date.
		*/
		public void set_Since(String value) {
			this.setInput("Since", value);
		}


		/** 
		Set the value of the Sort input for this Choreo. 

		@param String - (optional, string) Indicates how the issues will be sorted in the response. Valid sort options are: created (the default), updated, comments.
		*/
		public void set_Sort(String value) {
			this.setInput("Sort", value);
		}


		/** 
		Set the value of the State input for this Choreo. 

		@param String - (optional, string) Returns issues with a particular state: open (the default) or closed.
		*/
		public void set_State(String value) {
			this.setInput("State", value);
		}


		/** 
		Set the value of the User input for this Choreo. 

		@param String - (required, string) A GitHub username.
		*/
		public void set_User(String value) {
			this.setInput("User", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the ListIssuesForRepo Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class ListIssuesForRepoResultSet extends ResultSet {
		public ListIssuesForRepoResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "FirstPage" output from this Choreo execution

		@return String - (integer) The index for the first page of results.
		*/
		public String get_FirstPage() {
			return this.getResultString("FirstPage");
		}
		/** 
		Retrieve the value for the "LastPage" output from this Choreo execution

		@return String - (integer) The index for the last page of results.
		*/
		public String get_LastPage() {
			return this.getResultString("LastPage");
		}
		/** 
		Retrieve the value for the "Limit" output from this Choreo execution

		@return String - (integer) The available rate limit for your account. This is returned in the GitHub response header.
		*/
		public String get_Limit() {
			return this.getResultString("Limit");
		}
		/** 
		Retrieve the value for the "NextPage" output from this Choreo execution

		@return String - (integer) The index for the next page of results.
		*/
		public String get_NextPage() {
			return this.getResultString("NextPage");
		}
		/** 
		Retrieve the value for the "PreviousPage" output from this Choreo execution

		@return String - (integer) The index for the previous page of results.
		*/
		public String get_PreviousPage() {
			return this.getResultString("PreviousPage");
		}
		/** 
		Retrieve the value for the "Remaining" output from this Choreo execution

		@return String - (integer) The remaining number of API requests available to you. This is returned in the GitHub response header.
		*/
		public String get_Remaining() {
			return this.getResultString("Remaining");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from GitHub.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
