package com.temboo.Library.Foursquare.Checkins;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateCheckin

Allows you to create a check-in with Foursquare.
*/
public class CreateCheckin extends Choreography {

	/**
	Create a new instance of the CreateCheckin Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateCheckin(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Foursquare/Checkins/CreateCheckin"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateCheckinInputSet
	*/
	public CreateCheckinInputSet newInputSet() {
		return new CreateCheckinInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateCheckinResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateCheckinResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateCheckin
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateCheckinInputSet extends InputSet {
		/** 
		Set the value of the AccuracyOfCoordinates input for this Choreo. 

		@param Integer - (optional, integer) Accuracy of the user's latitude and longitude, in meters.
		*/
		public void set_AccuracyOfCoordinates(Integer value) {
			this.setInput("AccuracyOfCoordinates", value);
		}

		/** 
		Set the value of the AccuracyOfCoordinates input for this Choreo as a String. 

		@param String - (optional, integer) Accuracy of the user's latitude and longitude, in meters.
		*/
		public void set_AccuracyOfCoordinates(String value) {
			this.setInput("AccuracyOfCoordinates", value);	
		}
		/** 
		Set the value of the Altitude input for this Choreo. 

		@param Integer - (optional, integer) Altitude of the user's location, in meters.
		*/
		public void set_Altitude(Integer value) {
			this.setInput("Altitude", value);
		}

		/** 
		Set the value of the Altitude input for this Choreo as a String. 

		@param String - (optional, integer) Altitude of the user's location, in meters.
		*/
		public void set_Altitude(String value) {
			this.setInput("Altitude", value);	
		}
		/** 
		Set the value of the AltitudeAccuracy input for this Choreo. 

		@param Integer - (optional, integer) Vertical accuracy of the user's location, in meters.
		*/
		public void set_AltitudeAccuracy(Integer value) {
			this.setInput("AltitudeAccuracy", value);
		}

		/** 
		Set the value of the AltitudeAccuracy input for this Choreo as a String. 

		@param String - (optional, integer) Vertical accuracy of the user's location, in meters.
		*/
		public void set_AltitudeAccuracy(String value) {
			this.setInput("AltitudeAccuracy", value);	
		}
		/** 
		Set the value of the Broadcast input for this Choreo. 

		@param String - (optional, string) Who to broadcast this check-in to. Can be a comma-delimited list: private, public, facebook, twitter, or followers. Defaults to 'public'.
		*/
		public void set_Broadcast(String value) {
			this.setInput("Broadcast", value);
		}


		/** 
		Set the value of the EventID input for this Choreo. 

		@param String - (optional, string) The event the user is checking in to. A venueId for a venue with this eventId must also be specified in the request.
		*/
		public void set_EventID(String value) {
			this.setInput("EventID", value);
		}


		/** 
		Set the value of the Latitude input for this Choreo. 

		@param BigDecimal - (optional, decimal) The latitude point of the user's location.
		*/
		public void set_Latitude(BigDecimal value) {
			this.setInput("Latitude", value);
		}

		/** 
		Set the value of the Latitude input for this Choreo as a String. 

		@param String - (optional, decimal) The latitude point of the user's location.
		*/
		public void set_Latitude(String value) {
			this.setInput("Latitude", value);	
		}
		/** 
		Set the value of the Longitude input for this Choreo. 

		@param BigDecimal - (optional, decimal) The longitude point of the user's location.
		*/
		public void set_Longitude(BigDecimal value) {
			this.setInput("Longitude", value);
		}

		/** 
		Set the value of the Longitude input for this Choreo as a String. 

		@param String - (optional, decimal) The longitude point of the user's location.
		*/
		public void set_Longitude(String value) {
			this.setInput("Longitude", value);	
		}
		/** 
		Set the value of the OauthToken input for this Choreo. 

		@param String - (required, string) The FourSquare API Oauth token string.
		*/
		public void set_OauthToken(String value) {
			this.setInput("OauthToken", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Shout input for this Choreo. 

		@param String - (optional, string) A message about your check-in. The maximum length of this field is 140 characters.
		*/
		public void set_Shout(String value) {
			this.setInput("Shout", value);
		}


		/** 
		Set the value of the Venue input for this Choreo. 

		@param String - (optional, string) If you are not shouting, but you don't have a venue ID or prefer a 'venueless' checkin, pass the venue name as a string using this parameter.
		*/
		public void set_Venue(String value) {
			this.setInput("Venue", value);
		}


		/** 
		Set the value of the VenueID input for this Choreo. 

		@param String - (required, string) The venue where the user is checking in. No venueid is needed if shouting or just providing a venue name.
		*/
		public void set_VenueID(String value) {
			this.setInput("VenueID", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateCheckin Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateCheckinResultSet extends ResultSet {
		public CreateCheckinResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Foursquare. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
