package com.temboo.Library.Facebook.Actions.Music.Listens;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateListen

Creates an action that represents a user listening to music.
*/
public class CreateListen extends Choreography {

	/**
	Create a new instance of the CreateListen Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateListen(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Facebook/Actions/Music/Listens/CreateListen"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateListenInputSet
	*/
	public CreateListenInputSet newInputSet() {
		return new CreateListenInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateListenResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateListenResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateListen
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateListenInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token retrieved from the final step of the OAuth process.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Album input for this Choreo. 

		@param String - (conditional, string) The URL or ID for an Open Graph object representing  representing an album.
		*/
		public void set_Album(String value) {
			this.setInput("Album", value);
		}


		/** 
		Set the value of the CreatedTime input for this Choreo. 

		@param String - (optional, date) The time that the action was created (e.g. 2013-06-24T18:53:35+0000).
		*/
		public void set_CreatedTime(String value) {
			this.setInput("CreatedTime", value);
		}


		/** 
		Set the value of the EndTime input for this Choreo. 

		@param String - (optional, date) The time that the user ended the action (e.g. 2013-06-24T18:53:35+0000).
		*/
		public void set_EndTime(String value) {
			this.setInput("EndTime", value);
		}


		/** 
		Set the value of the ExpiresIn input for this Choreo. 

		@param Integer - (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
		*/
		public void set_ExpiresIn(Integer value) {
			this.setInput("ExpiresIn", value);
		}

		/** 
		Set the value of the ExpiresIn input for this Choreo as a String. 

		@param String - (optional, integer) The amount of time (in milliseconds) from the publish_time that the action will expire.
		*/
		public void set_ExpiresIn(String value) {
			this.setInput("ExpiresIn", value);	
		}
		/** 
		Set the value of the ExplicitlyShared input for this Choreo. 

		@param Boolean - (optional, boolean) Indicates that the user is explicitly sharing this action. Requires the explicitly_shared capability to be enabled.
		*/
		public void set_ExplicitlyShared(Boolean value) {
			this.setInput("ExplicitlyShared", value);
		}

		/** 
		Set the value of the ExplicitlyShared input for this Choreo as a String. 

		@param String - (optional, boolean) Indicates that the user is explicitly sharing this action. Requires the explicitly_shared capability to be enabled.
		*/
		public void set_ExplicitlyShared(String value) {
			this.setInput("ExplicitlyShared", value);	
		}
		/** 
		Set the value of the ExplicityShared input for this Choreo. 

		@param Boolean - (optional, boolean) Deprecated (retained for backward compatibility only).
		*/
		public void set_ExplicityShared(Boolean value) {
			this.setInput("ExplicityShared", value);
		}

		/** 
		Set the value of the ExplicityShared input for this Choreo as a String. 

		@param String - (optional, boolean) Deprecated (retained for backward compatibility only).
		*/
		public void set_ExplicityShared(String value) {
			this.setInput("ExplicityShared", value);	
		}
		/** 
		Set the value of the Message input for this Choreo. 

		@param String - (optional, string) A message attached to this action. Setting this parameter requires enabling of message capabilities.
		*/
		public void set_Message(String value) {
			this.setInput("Message", value);
		}


		/** 
		Set the value of the Musician input for this Choreo. 

		@param String - (conditional, string) The URL or ID for an Open Graph object representing representing a musician.
		*/
		public void set_Musician(String value) {
			this.setInput("Musician", value);
		}


		/** 
		Set the value of the NoFeedStory input for this Choreo. 

		@param Boolean - (optional, boolean) Whether or not this action should be posted to the users feed.
		*/
		public void set_NoFeedStory(Boolean value) {
			this.setInput("NoFeedStory", value);
		}

		/** 
		Set the value of the NoFeedStory input for this Choreo as a String. 

		@param String - (optional, boolean) Whether or not this action should be posted to the users feed.
		*/
		public void set_NoFeedStory(String value) {
			this.setInput("NoFeedStory", value);	
		}
		/** 
		Set the value of the Paused input for this Choreo. 

		@param Boolean - (optional, boolean) Whether the audio is paused or not
		*/
		public void set_Paused(Boolean value) {
			this.setInput("Paused", value);
		}

		/** 
		Set the value of the Paused input for this Choreo as a String. 

		@param String - (optional, boolean) Whether the audio is paused or not
		*/
		public void set_Paused(String value) {
			this.setInput("Paused", value);	
		}
		/** 
		Set the value of the Place input for this Choreo. 

		@param String - (optional, string) The URL or ID for an Open Graph object representing the location associated with this action.
		*/
		public void set_Place(String value) {
			this.setInput("Place", value);
		}


		/** 
		Set the value of the Playlist input for this Choreo. 

		@param String - (conditional, string) The URL or ID for an Open Graph object representing representing a playlist.
		*/
		public void set_Playlist(String value) {
			this.setInput("Playlist", value);
		}


		/** 
		Set the value of the ProfileID input for this Choreo. 

		@param String - (optional, string) The id of the user's profile. Defaults to "me" indicating the authenticated user.
		*/
		public void set_ProfileID(String value) {
			this.setInput("ProfileID", value);
		}


		/** 
		Set the value of the RadioStation input for this Choreo. 

		@param String - (conditional, string) The URL or ID for an Open Graph object representing  representing a radio station
		*/
		public void set_RadioStation(String value) {
			this.setInput("RadioStation", value);
		}


		/** 
		Set the value of the Reference input for this Choreo. 

		@param String - (optional, string) A string identifier up to 50 characters used for tracking and insights.
		*/
		public void set_Reference(String value) {
			this.setInput("Reference", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Song input for this Choreo. 

		@param String - (conditional, string) The URL or ID for an Open Graph object representing  representing a song.
		*/
		public void set_Song(String value) {
			this.setInput("Song", value);
		}


		/** 
		Set the value of the StartTime input for this Choreo. 

		@param String - (optional, date) The time that the user started the action (e.g. 2013-06-24T18:53:35+0000).
		*/
		public void set_StartTime(String value) {
			this.setInput("StartTime", value);
		}


		/** 
		Set the value of the Tags input for this Choreo. 

		@param String - (optional, string) A comma separated list of other profile IDs that also performed this action.
		*/
		public void set_Tags(String value) {
			this.setInput("Tags", value);
		}


		/** 
		Set the value of the ViaUser input for this Choreo. 

		@param Integer - (optional, integer) The ID of anyone whom the user discovered this audio from
		*/
		public void set_ViaUser(Integer value) {
			this.setInput("ViaUser", value);
		}

		/** 
		Set the value of the ViaUser input for this Choreo as a String. 

		@param String - (optional, integer) The ID of anyone whom the user discovered this audio from
		*/
		public void set_ViaUser(String value) {
			this.setInput("ViaUser", value);	
		}
	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateListen Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateListenResultSet extends ResultSet {
		public CreateListenResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "ActivityURL" output from this Choreo execution

		@return String - (string) The URL for the newly created action.
		*/
		public String get_ActivityURL() {
			return this.getResultString("ActivityURL");
		}
		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Facebook. Corresponds to the ResponseFormat input. Defaults to JSON.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
