package com.temboo.Library.Dropbox.FilesAndMetadata;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
LongPollDelta

Used in conjunction with the Delta Choreo, this allows you to perform a long-poll request to wait for changes on an account.
*/
public class LongPollDelta extends Choreography {

	/**
	Create a new instance of the LongPollDelta Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public LongPollDelta(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Dropbox/FilesAndMetadata/LongPollDelta"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return LongPollDeltaInputSet
	*/
	public LongPollDeltaInputSet newInputSet() {
		return new LongPollDeltaInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public LongPollDeltaResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new LongPollDeltaResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the LongPollDelta
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class LongPollDeltaInputSet extends InputSet {
		/** 
		Set the value of the Cursor input for this Choreo. 

		@param String - (required, string) A delta cursor as returned from a call to the Delta Choreo.
		*/
		public void set_Cursor(String value) {
			this.setInput("Cursor", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Can be set to xml or json. Defaults to json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Timeout input for this Choreo. 

		@param String - (optional, string) An integer indicating the amount of time, in seconds, to wait for a response. The default value is 30 seconds, which is also the minimum allowed value. The maximum is 480 seconds.
		*/
		public void set_Timeout(String value) {
			this.setInput("Timeout", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the LongPollDelta Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class LongPollDeltaResultSet extends ResultSet {
		public LongPollDeltaResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Dropbox. Corresponds to the ResponseFormat input. Defaults to json.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
