package com.temboo.Library.Dropbox.Files;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
Download

Downloads a file from a user's Dropbox.
*/
public class Download extends Choreography {

	/**
	Create a new instance of the Download Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public Download(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Dropbox/Files/Download"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return DownloadInputSet
	*/
	public DownloadInputSet newInputSet() {
		return new DownloadInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public DownloadResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new DownloadResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the Download
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class DownloadInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token for a specific Dropbox user.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Encode input for this Choreo. 

		@param Boolean - (optional, boolean) Binary files must be returned as Base64-encoded data. If the file you are donwloading is plain text, you can set this to false to return the raw data. Defaults to true. 
		*/
		public void set_Encode(Boolean value) {
			this.setInput("Encode", value);
		}

		/** 
		Set the value of the Encode input for this Choreo as a String. 

		@param String - (optional, boolean) Binary files must be returned as Base64-encoded data. If the file you are donwloading is plain text, you can set this to false to return the raw data. Defaults to true. 
		*/
		public void set_Encode(String value) {
			this.setInput("Encode", value);	
		}
		/** 
		Set the value of the Path input for this Choreo. 

		@param String - (required, string) The path of the file to download.
		*/
		public void set_Path(String value) {
			this.setInput("Path", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the Download Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class DownloadResultSet extends ResultSet {
		public DownloadResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response from Dropbox.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
