package com.temboo.Library.Dropbox.Files;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CreateFolder

Creates a folder at a given path.
*/
public class CreateFolder extends Choreography {

	/**
	Create a new instance of the CreateFolder Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CreateFolder(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Dropbox/Files/CreateFolder"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CreateFolderInputSet
	*/
	public CreateFolderInputSet newInputSet() {
		return new CreateFolderInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CreateFolderResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CreateFolderResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CreateFolder
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CreateFolderInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) The access token for a specific Dropbox user.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the AutoRename input for this Choreo. 

		@param Boolean - (optional, boolean) If there's a conflict, have the Dropbox server try to autorename the file to avoid the conflict. The default for this field is false.
		*/
		public void set_AutoRename(Boolean value) {
			this.setInput("AutoRename", value);
		}

		/** 
		Set the value of the AutoRename input for this Choreo as a String. 

		@param String - (optional, boolean) If there's a conflict, have the Dropbox server try to autorename the file to avoid the conflict. The default for this field is false.
		*/
		public void set_AutoRename(String value) {
			this.setInput("AutoRename", value);	
		}
		/** 
		Set the value of the Path input for this Choreo. 

		@param String - (required, string) Path in the user's Dropbox to create.
		*/
		public void set_Path(String value) {
			this.setInput("Path", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CreateFolder Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CreateFolderResultSet extends ResultSet {
		public CreateFolderResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Dropbox.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
