package com.temboo.Library.Disqus.Users;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
CheckUsername

Check whether the provided username is available.  An error is returned if the entered username is either taken, or invalid.
*/
public class CheckUsername extends Choreography {

	/**
	Create a new instance of the CheckUsername Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public CheckUsername(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/Disqus/Users/CheckUsername"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return CheckUsernameInputSet
	*/
	public CheckUsernameInputSet newInputSet() {
		return new CheckUsernameInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public CheckUsernameResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new CheckUsernameResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the CheckUsername
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class CheckUsernameInputSet extends InputSet {
		/** 
		Set the value of the AccessToken input for this Choreo. 

		@param String - (required, string) A valid OAuth 2.0 access token.
		*/
		public void set_AccessToken(String value) {
			this.setInput("AccessToken", value);
		}


		/** 
		Set the value of the Callback input for this Choreo. 

		@param String - (optional, string) The name of a callback function to wrap the respone in. Used when setting ResponseFormat to "jsonp".
		*/
		public void set_Callback(String value) {
			this.setInput("Callback", value);
		}


		/** 
		Set the value of the PublicKey input for this Choreo. 

		@param String - (required, string) The Public Key provided by Disqus (AKA the API Key).
		*/
		public void set_PublicKey(String value) {
			this.setInput("PublicKey", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: json (the default) and jsonp.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


		/** 
		Set the value of the Username input for this Choreo. 

		@param String - (required, string) Enter a Disqus username.
		*/
		public void set_Username(String value) {
			this.setInput("Username", value);
		}


		/** 
		Set the value of the VaultFile input for this Choreo. 

		@param TembooPath - 
		*/

	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the CheckUsername Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class CheckUsernameResultSet extends ResultSet {
		public CheckUsernameResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - (json) The response from Disqus.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
