package com.temboo.Library.DataGov;

/*
Copyright 2014 Temboo, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONException;
import java.math.BigDecimal;
import com.temboo.core.Choreography;
import com.temboo.core.Choreography.ResultSet;
import com.temboo.core.Choreography.InputSet;
import com.temboo.core.TembooException;
import com.temboo.core.TembooPath;
import com.temboo.core.TembooSession;

/** 
GetDemographicsByTypeAndID

Retrieve demographic data for a specified geography type and geography ID.
*/
public class GetDemographicsByTypeAndID extends Choreography {

	/**
	Create a new instance of the GetDemographicsByTypeAndID Choreo. A TembooSession object, containing a valid
	set of Temboo credentials, must be supplied.
	*/
	public GetDemographicsByTypeAndID(TembooSession session) {
		super(session, TembooPath.pathFromStringNoException("/Library/DataGov/GetDemographicsByTypeAndID"));
	}


	/** 
	Obtain an InputSet object, used to define inputs for an execution of this Choreo.
	
	@return GetDemographicsByTypeAndIDInputSet
	*/
	public GetDemographicsByTypeAndIDInputSet newInputSet() {
		return new GetDemographicsByTypeAndIDInputSet();
	}
	
	
	/**
	 * Execute the Choreo using the specified InputSet as parameters, wait for the Choreo to complete 
	 * and return a ResultSet containing the execution results.
	 * @param choreoInputs
	 * @return
	 * @throws TembooException
	 */
	 @Override
	public GetDemographicsByTypeAndIDResultSet execute(InputSet choreoInputs) throws TembooException {
		JSONObject result = super.executeWithResults(choreoInputs);
		return new GetDemographicsByTypeAndIDResultSet(result);
	}
	
	
	/**
		An InputSet with methods appropriate for specifying the inputs to the GetDemographicsByTypeAndID
        Choreo. The InputSet object is used to specify input parameters when executing this choreo.
	*/
	public static class GetDemographicsByTypeAndIDInputSet extends InputSet {
		/** 
		Set the value of the DataVersion input for this Choreo. 

		@param String - (optional, string) Specify the census data version to search. Valid values are: jun2011, dec2011, jun2012, and dec2012.
		*/
		public void set_DataVersion(String value) {
			this.setInput("DataVersion", value);
		}


		/** 
		Set the value of the GeographyIDs input for this Choreo. 

		@param Integer - (conditional, integer) The geography IDs to search for. Separate multiple IDs by commas; a maximum of 10 IDs are allowed.
		*/
		public void set_GeographyIDs(Integer value) {
			this.setInput("GeographyIDs", value);
		}

		/** 
		Set the value of the GeographyIDs input for this Choreo as a String. 

		@param String - (conditional, integer) The geography IDs to search for. Separate multiple IDs by commas; a maximum of 10 IDs are allowed.
		*/
		public void set_GeographyIDs(String value) {
			this.setInput("GeographyIDs", value);	
		}
		/** 
		Set the value of the GeographyType input for this Choreo. 

		@param String - (required, string) Specify one of the following geography type values: "state", "county", "tract", "block", "congdistrict", "statehouse", "statesenate", "censusplace", or "msa" (metropolitan statistical area).
		*/
		public void set_GeographyType(String value) {
			this.setInput("GeographyType", value);
		}


		/** 
		Set the value of the ResponseFormat input for this Choreo. 

		@param String - (optional, string) The format that the response should be in. Valid values are: xml (the default) and json.
		*/
		public void set_ResponseFormat(String value) {
			this.setInput("ResponseFormat", value);
		}


	}
	
	
	/**
		A ResultSet with methods tailored to the values returned by the GetDemographicsByTypeAndID Choreo.
        The ResultSet object is used to retrieve the results of a Choreo execution.
	*/
	public static class GetDemographicsByTypeAndIDResultSet extends ResultSet {
		public GetDemographicsByTypeAndIDResultSet(JSONObject doc) throws TembooException {
			super(doc);
		}

		/** 
		Retrieve the value for the "Response" output from this Choreo execution

		@return String - The response returned from the API.
		*/
		public String get_Response() {
			return this.getResultString("Response");
		}
	}
	
}
